% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimates.R
\name{estimates.nlist}
\alias{estimates.nlist}
\title{Estimates}
\usage{
\method{estimates}{nlist}(x, fun = median, ...)
}
\arguments{
\item{x}{An object.}

\item{fun}{A function that given a numeric vector returns a numeric scalar.}

\item{...}{Additional arguments passed to fun.}
}
\value{
A list of uniquely named numeric objects.
}
\description{
Calculates the estimates for an MCMC object.
}
\examples{
estimates(nlist(x = 1:9))
estimates(nlist(y = 3:5, zz = matrix(1:9, 3)))
}
\seealso{
Other MCMC manipulations: 
\code{\link[universals]{bind_chains}()},
\code{\link[universals]{collapse_chains}()},
\code{\link[universals]{split_chains}()}
}
