% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliersMD.R
\name{outliersMD}
\alias{outliersMD}
\title{Mahalanobis distance to detect bivariate outliers}
\usage{
outliersMD(x, y, alpha = 0.001)
}
\arguments{
\item{x}{Numeric vector}

\item{y}{Numeric vector}

\item{alpha}{Critical \code{alpha} value to detect and outlier (defaults to
0.001)}
}
\value{
A logical vector (TRUE for an outlier at \code{p < alpha})
}
\description{
Mahalanobis distance to detect bivariate outliers
}
\examples{
# Use outliersMD() to detect outliers in an anthropometric data from
# a SMART survey from the Democratic Republic of Congo (sp.ex01)
svy <- sp.ex01
svy[outliersMD(svy$height,svy$weight), ]
}
