% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbernppLocalDetection_normal.R
\name{dbernppLocalDetection_normal}
\alias{dbernppLocalDetection_normal}
\alias{rbernppLocalDetection_normal}
\title{Local evaluation for a Bernoulli point process detection model}
\usage{
dbernppLocalDetection_normal(
  x,
  lowerCoords,
  upperCoords,
  s,
  sd,
  baseIntensities,
  habitatGridLocal,
  resizeFactor = 1,
  localObsWindowIndices,
  numLocalObsWindows,
  numWindows,
  indicator,
  log = 0
)

rbernppLocalDetection_normal(
  n,
  lowerCoords,
  upperCoords,
  s,
  sd,
  baseIntensities,
  habitatGridLocal,
  resizeFactor = 1,
  localObsWindowIndices,
  numLocalObsWindows,
  numWindows,
  indicator
)
}
\arguments{
\item{x}{Vector with three elements representing the x- and y-coordinates (x[1:2]), and the corresponding id the detection window (x[3]) of a single spatial point (detection location) scaled to the habitat (see \code{scaleCoordsToHabitatGrid}).}

\item{lowerCoords, upperCoords}{Matrices of lower and upper x- and y-coordinates of all detection windows. One row for each window.
Each window should be of size 1x1 (after rescaling if necessary).}

\item{s}{Vector of x- and y-coordinates of the isotropic bivariate normal distribution mean (i.e. the AC location).}

\item{sd}{Standard deviation of the bivariate normal distribution.}

\item{baseIntensities}{Vector of baseline detection intensities for all detection windows.}

\item{habitatGridLocal}{Matrix of rescaled habitat grid cells indices, as returned by the \code{getLocalObjects} function (object named \code{habitatGrid}).}

\item{resizeFactor}{Aggregation factor used in the  \code{getLocalObjects} function to reduce the number of habitat grid cells.}

\item{localObsWindowIndices}{Matrix of indices of local observation windows around each local habitat grid cell (habitatGridLocal), from localIndices returned by the \code{getLocalObjects} function.}

\item{numLocalObsWindows}{Vector of numbers of local observation windows around all habitat grid cells, as returned by the getLocalObjects function (object named \code{numLocalIndices}). 
The ith number gives the number of local (original) observation windows for the ith (rescaled) habitat window.}

\item{numWindows}{Number of detection windows. This value (positive integer) is used to truncate \code{lowerCoords} and \code{upperCoords} 
so that extra rows beyond \code{numWindows} are ignored.}

\item{indicator}{Binary argument specifying whether the individual is available for detection (indicator = 1) or not (indicator = 0).}

\item{log}{Logical argument, specifying whether to return the log-probability of the distribution.}

\item{n}{Integer specifying the number of realizations to generate.  Only n = 1 is supported.}
}
\value{
The (log) probability density of the observation vector \code{x}.
}
\description{
Density and random generation functions of the Bernoulli point process for detection based on a bivariate normal distribution.
}
\details{
The \code{dbernppDetection_normal} distribution is a NIMBLE custom distribution which can be used to model and simulate
Bernoulli observations (\emph{x}) of a single individual in continuous space over a set of detection windows defined by their upper and lower
coordinates (\emph{lowerCoords,upperCoords}). The distribution assumes that an individual’s detection probability 
follows an isotropic multivariate normal centered on the individual's activity center (\emph{s}) with standard deviation (\emph{sd}).
The local evaluation approach is implemented.
}
\examples{

# Create habitat grid
coordsHabitatGridCenter <- matrix(c(0.5, 3.5,
                                    1.5, 3.5,
                                    2.5, 3.5,
                                    3.5, 3.5,
                                    0.5, 2.5,
                                    1.5, 2.5,
                                    2.5, 2.5,
                                    3.5, 2.5,
                                    0.5, 1.5,
                                    1.5, 1.5,
                                    2.5, 1.5,
                                    3.5, 1.5,
                                    0.5, 0.5,
                                    1.5, 0.5,
                                    2.5, 0.5,
                                    3.5, 0.5), ncol = 2,byrow = TRUE)
colnames(coordsHabitatGridCenter) <- c("x","y")
# Create observation windows
lowerCoords <- matrix(c(1, 1, 2, 1, 1, 2, 2, 2), nrow = 4, byrow = TRUE)
upperCoords <- matrix(c(2, 2, 3, 2, 2, 3, 3, 3), nrow = 4, byrow = TRUE)  
colnames(lowerCoords) <- colnames(upperCoords) <- c("x","y")
# Plot check
plot(coordsHabitatGridCenter[,"y"]~coordsHabitatGridCenter[,"x"],pch=16) 
points(lowerCoords[,"y"]~lowerCoords[,"x"],col="red",pch=16) 
points(upperCoords[,"y"]~upperCoords[,"x"],col="red",pch=16) 
#'
s <- c(1, 1)
sd <- 0.1
baseIntensities <- c(1:4)
windowIndex <- 4
numPoints <- 1
numWindows <- 4
indicator <- 1

# Rescale coordinates
ScaledLowerCoords <- scaleCoordsToHabitatGrid(coordsData =  lowerCoords,
                                              coordsHabitatGridCenter = coordsHabitatGridCenter)
ScaledUpperCoords <- scaleCoordsToHabitatGrid(coordsData =  upperCoords,
                                              coordsHabitatGridCenter = coordsHabitatGridCenter)
ScaledUpperCoords$coordsDataScaled[,2] <- ScaledUpperCoords$coordsDataScaled[,2] + 1.5
ScaledLowerCoords$coordsDataScaled[,2] <- ScaledLowerCoords$coordsDataScaled[,2] - 1.5
habitatMask <- matrix(1, nrow = 4, ncol=4, byrow = TRUE)
# Create local objects 
ObsWindowsLocal <- getLocalObjects(habitatMask = habitatMask,
                                   coords = ScaledLowerCoords$coordsDataScaled,
                                   dmax=3,
                                   resizeFactor = 1,
                                   plot.check = TRUE
)
x <- c(1.1, 1.2)
windowIndex <- getWindowIndex(curCoords = x,
                              lowerCoords = ScaledLowerCoords$coordsDataScaled,
                              upperCoords =ScaledUpperCoords$coordsDataScaled)
x <- c(x, windowIndex)
dbernppLocalDetection_normal(x, ScaledLowerCoords$coordsDataScaled,
                             ScaledUpperCoords$coordsDataScaled,
                             s, sd, baseIntensities,  
                             ObsWindowsLocal$habitatGrid, ObsWindowsLocal$resizeFactor,
                             ObsWindowsLocal$localIndices,ObsWindowsLocal$numLocalIndices,
                             numWindows, indicator, log = TRUE)
}
\references{
W. Zhang, J. D. Chipperfield, J. B. Illian, P. Dupont, C. Milleret, P. de Valpine and R. Bischof. 2020. 
A hierarchical point process model for spatial capture-recapture data. bioRxiv. DOI 10.1101/2020.10.06.325035 

C. Milleret, P. Dupont, C. Bonenfant, H. Brøseth, Ø. Flagstad, C. Sutherland and R. Bischof. 2019. 
A local evaluation of the individual state-space to scale up Bayesian spatial capture-recapture. Ecology and Evolution 9:352-363
}
\author{
Wei Zhang and Cyril Milleret
}
