% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSparseY.R
\name{getSparseY}
\alias{getSparseY}
\title{Sparse Matrix Preparation}
\usage{
getSparseY(x, noDetections = -1)
}
\arguments{
\item{x}{A two- or three-dimensional observation data array.}

\item{noDetections}{The value indicating no detection. Defaults to -1.}
}
\value{
a list of objects which constitute a sparse representation of the observation data:

\itemize{
\item \emph{detNums} a vector of the number of traps at which each individual was detected.
\item \emph{maxDetNums} the maximum number of traps at which any individual was detected (i.e, the maximum of detNums).
\item \emph{detIndices} a matrix of dimensions n.individuals * maxDetNums which contains the IDs of the traps. 
where each individuals was detected.
\item \emph{y} a matrix of dimensions n.individuals * maxDetNums which contains the number of observations of each individual
at the traps it was detected at.
}
}
\description{
R utility function to turn a two or three-dimensional detection array into a sparse matrix representation.
Used in the implementation of the \code{\link{dbinom_sparseLocalSCR}} function.
}
\details{
The \code{getSparseY} function is used in advance of model building to create a sparse matrix representation of the observation data. 
It creates and returns a list of objects:
}
\examples{
y.full <- matrix(rbinom(5000, 5, 0.02), ncol = 100)

y <- getSparseY(y.full)

}
\author{
Cyril Milleret
}
