% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmpi7IeZS/filee6c5f56c1db
\name{modelValuesConf}
\alias{modelValuesConf}
\title{Create the confs for a custom NIMBLE modelValues object}
\usage{
modelValuesConf(symTab, className, vars, types, sizes, modelDef = NA,
  where = globalenv())
}
\arguments{
\item{symTab}{For internal use only}

\item{className}{For internal use only}

\item{vars}{A vector of character strings naming each variable in the modelValues object}

\item{types}{A vector of character strings describing the type of data for the modelValues object.
Options include `double' (for real-valued variables) and `int'.}

\item{sizes}{A list in which the named items of the list match the \code{var} arguments and each item is a numeric vector of the dimensions}

\item{modelDef}{For internal use only}

\item{where}{For internal use only}
}
\description{
Builds an R-based modelValues conf object
}
\details{
See the User Manual or \code{help(modelValuesBaseClass)} and \code{help(modelValues)} for information
}
\examples{
#Custom modelValues object:
mvConf <- modelValuesConf(vars = c('x', 'y'),
				types = c('double', 'int'),
				sizes = list(x = 3, y = c(2,2)))
custom_mv <- modelValues(mvConf, m = 2)
custom_mv['y',]
}
\author{
Clifford Anderson-Bergman
}

