% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETo56_miss.R
\name{ETo56_miss}
\alias{ETo56_miss}
\title{Determination of ETo with missing data}
\usage{
ETo56_miss(lat, z, doy, tmax, tmin, tdew, u2, Rs, P)
}
\arguments{
\item{lat}{Latitude in decimal degrees.}

\item{z}{Elevation above sea level in meters.}

\item{doy}{Day of the year.}

\item{tmax}{Maximum air temperature in Celsius degrees.}

\item{tmin}{Minimum air temperature in Celsius degrees.}

\item{tdew}{Dewpoint temperature in Celsius degrees.}

\item{u2}{Wind speed at 2 m height in m s-1.}

\item{Rs}{Solar radiation in MJ/sq.m/day.}

\item{P}{Atmospheric pressure  in kPa.}
}
\value{
Reference Evapotranspiration in mm day-1
}
\description{
This function is used to the estimation of monthly ETo with the FAO Penman-Montheith equation for a data set containing only maximum and minimum air temperature.
Please, see the example 20 from the FAO Irrigation and drainage paper 56.
}
\examples{
ETo56_miss(45.72, 200, 196, 26.6, 14.8, 14.8, 2, 22.29, 98.96)

}
\references{
Allen et al., 1998. Crop Evapotranspiration. Guidelines for computing crop water requirements. FAO Irrigation and drainage paper 56.
\url{http://www.fao.org/3/X0490E/x0490e00.htm}.
}
