% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_valid.R
\name{is_valid}
\alias{is_valid}
\title{Checks validity of NHS numbers}
\usage{
is_valid(nhs_number, warn = TRUE)
}
\arguments{
\item{nhs_number}{A vector of 10 digit NHS numbers to validate}

\item{warn}{Boolean that controls display of warning messages}
}
\value{
A logical vector indicating the validity of each input value
}
\description{
NHS numbers are 10 digit numbers where the 10th digit is a checksum.
This function validates the checksums of the supplied NHS numbers.
}
\examples{
is_valid(1234567881)
is_valid(c(1234567881, 1234512345, 123456789))
is_valid(1234567890, warn = FALSE)
}
