% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model.R
\name{calculate_expected_goals_v2}
\alias{calculate_expected_goals_v2}
\alias{calculate_xG_v2}
\title{Calculate version 2 of the expected goals for all the events (plays) in a
play-by-play}
\usage{
calculate_expected_goals_v2(play_by_play)

calculate_xG_v2(play_by_play)
}
\arguments{
\item{play_by_play}{data.frame of play-by-play(s); see \code{\link[=gc_play_by_play]{gc_play_by_play()}}
and/or \code{\link[=wsc_play_by_play]{wsc_play_by_play()}} for reference; must be untouched by
non-nhlscraper functions; saves time if \code{\link[=calculate_distance]{calculate_distance()}},
\code{\link[=calculate_angle]{calculate_angle()}}, \code{\link[=strip_situation_code]{strip_situation_code()}}, \code{\link[=flag_is_rebound]{flag_is_rebound()}}, and/or
\code{\link[=flag_is_rush]{flag_is_rush()}} have already been called}
}
\value{
data.frame with one row per event (play) and added \code{xG_v2} column
}
\description{
\code{calculate_expected_goals_v2()} calculates version 2 of the expected goals
for all the events (plays) in a play-by-play using a pre-estimated logistic
regression model of goal probability on distance, angle, empty net, strength
state, rebound, and rush indicators.
}
\examples{
# May take >5s, so skip.
\donttest{
  test <- gc_play_by_play()
  test <- calculate_expected_goals_v2(test)
}
}
