% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Team.R
\name{get_team_statistics}
\alias{get_team_statistics}
\title{Get team statistics by season}
\usage{
get_team_statistics(
  season = get_season_now()$seasonId,
  report = "summary",
  is_aggregate = FALSE,
  is_game = FALSE,
  dates = c("2025-01-01"),
  game_types = 1:3
)
}
\arguments{
\item{season}{integer Season in YYYYYYYY}

\item{report}{string Report (check \code{get_configuration()} for possible inputs)}

\item{is_aggregate}{boolean isAggregate where TRUE=regular and playoffs
combined, if applicable}

\item{is_game}{boolean isGame where TRUE=rows by games and FALSE=rows by
teams}

\item{dates}{vector of strings Date(s) in 'YYYY-MM-DD' (only if paired with
\code{is_game}; too many dates will result in incomplete data)}

\item{game_types}{vector of integers Game-type(s) where 1=pre-season,
2=regular, and 3=playoffs}
}
\value{
tibble with one row per team or game
}
\description{
Get team statistics by season
}
\examples{
playoff_team_stf_20242025 <- get_team_statistics(
  season=20242025,
  report='scoretrailfirst',
  game_types=c(3)
)

}
