% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name_cleaning.R
\name{clean_homeaway}
\alias{clean_homeaway}
\title{Clean Home/Away in dataframes into Team/Opponent dataframes}
\usage{
clean_homeaway(dataframe, invert = NULL)
}
\arguments{
\item{dataframe}{dataframe}

\item{invert}{a character vector of columns that gets inverted when referring to the away team (e.g. home spread = 1 gets converted to away_spread = -1)}
}
\value{
a dataframe with one row per team (twice as long as the input dataframe)
}
\description{
This function converts dataframes with "home_" and "away_" prefixed columns to "team_" and "opponent_", and doubles the rows. This makes sure that there's one row for each team (as opposed to one row for each game).
}
\examples{
\donttest{
# creating a small example dataframe!
cols <- c("season", "week", "home_team", "home_score",
          "away_team", "away_score", "result", "spread_line")

x <- as.data.frame(load_schedules(2020))
x <- utils::head(x[cols])

# how the data looks like
x

clean_homeaway(x, invert = c("result","spread_line"))
}
}
