% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/group.R
\docType{methods}
\name{extract}
\alias{extract}
\alias{extract-method}
\alias{extract,CompositionMatrix-method}
\title{Group-based Subset}
\usage{
extract(object, ...)

\S4method{extract}{CompositionMatrix}(object, name)
}
\arguments{
\item{object}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}

\item{name}{A \code{\link{character}} vector specifying the \link[=groups]{group} of
\code{object} to extract.}
}
\value{
A \code{\linkS4class{CompositionMatrix}} object.
}
\description{
Group-based Subset
}
\examples{
## Data from Aitchison 1986
data("slides")
head(slides)

## Coerce to compositional data
coda <- as_composition(slides, groups = 2)

groups(coda)
}
\seealso{
Other subsetting methods: 
\code{\link{bind}},
\code{\link{split}()},
\code{\link{subset}()}
}
\author{
N. Frerebeau
}
\concept{subsetting methods}
