% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/covariance.R
\docType{methods}
\name{covariance}
\alias{covariance}
\alias{covariance-method}
\alias{covariance,CompositionMatrix-method}
\alias{covariance,ALR-method}
\alias{covariance,CLR-method}
\title{Covariance Matrix}
\usage{
covariance(x, ...)

\S4method{covariance}{CompositionMatrix}(x, center = TRUE, method = "pearson")

\S4method{covariance}{ALR}(x, method = "pearson")

\S4method{covariance}{CLR}(x, method = "pearson")
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}

\item{center}{A \code{\link{logical}} scalar: should the \emph{centered} log-ratio
covariance matrix be computed?}

\item{method}{A \code{\link{character}} string indicating which covariance is to be
computed (see \code{\link[stats:cor]{stats::cov()}}).}
}
\value{
A \code{\link{matrix}}.
}
\description{
Computes the (centered) log-ratio covariance matrix (see below).
}
\section{Methods (by class)}{
\itemize{
\item \code{covariance(ALR)}: Computes the log-ratio covariance matrix
(Aitchison 1986, definition 4.5).

\item \code{covariance(CLR)}: Computes the centered log-ratio covariance matrix
(Aitchison 1986, definition 4.6).

}}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Log-ratio covariance matrix
## (Aitchison 1986, definition 4.5)
covariance(coda, center = FALSE)

## Centered log-ratio covariance matrix
## (Aitchison 1986, definition 4.6)
covariance(coda, center = TRUE)
}
\references{
Aitchison, J. (1986). \emph{The Statistical Analysis of Compositional Data}.
London: Chapman and Hall, p. 64-91.

Greenacre, M. J. (2019). \emph{Compositional Data Analysis in Practice}.
Boca Raton: CRC Press.
}
\seealso{
Other statistics: 
\code{\link{aggregate}()},
\code{\link{condense}()},
\code{\link{dist}},
\code{\link{mahalanobis}()},
\code{\link{margin}()},
\code{\link{mean}()},
\code{\link{pip}()},
\code{\link{quantile}()},
\code{\link{scale}()},
\code{\link{variance}()},
\code{\link{variance_total}()},
\code{\link{variation}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
