% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_img.R
\name{mask_img}
\alias{mask_img}
\title{Mask Image}
\usage{
mask_img(img, mask, allow.NA = TRUE)
}
\arguments{
\item{img}{object of class \code{nifti}}

\item{mask}{array or object of class \code{nifti}, same dimensions as img}

\item{allow.NA}{allow NAs in the mask}
}
\value{
Object of class nifti with values outside mask set to 0 if mask is
0 and NA if mask is NA and img if mask == 1
}
\description{
Takes an image, masks it by 
\code{mask}, and returns an object of class \code{nifti}
}
\examples{
  set.seed(5)
  dims = rep(10, 3)
  arr = array(rnorm(prod(dims)), dim = dims)
  nim = oro.nifti::nifti(arr)
  mask = abs(nim) > 1
  masked = mask_img(nim, mask)
  mask[mask == 0] = NA
  na_masked = mask_img(nim, mask, allow.NA = TRUE)
  
set.seed(5)
dims = rep(10, 3)
arr = array(rnorm(prod(dims)), dim = dims)
arr[,,10] = 0
nim = oro.nifti::nifti(arr)
rnifti = RNifti::asNifti(nim)
mask = nim > 0
timg = tempimg(nim)
limg = list(factor(timg), factor(timg))
func = function(...) mask_img(..., mask = mask)
func(arr)
func(nim)
func(rnifti)
func(timg)
lapply(limg, func)
}
