% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nettskjema_get_form.R
\name{nettskjema_get_data}
\alias{nettskjema_get_data}
\title{Get data from a form}
\usage{
nettskjema_get_data(
  form_id,
  information = NULL,
  use_codebook = TRUE,
  checkbox_type = c("string", "list", "columns"),
  checkbox_delim = ";",
  as_is = FALSE,
  from_date = "",
  from_submission = "",
  incremental = FALSE,
  token_name = "NETTSKJEMA_API_TOKEN",
  ...
)
}
\arguments{
\item{form_id}{integer. Number of the form to retrieve}

\item{information}{character or list vector of additional answer information
to add (One or more of "order", "option", "correct" "preselected"). If the list
is named, the additional information suffixes will be changed to the list names. If NULL (default) nothing is added.
Currently not combinable with \code{use_codebook = TRUE}.}

\item{use_codebook}{logical. Use codebook for retrieving answers (default TRUE). If you have not
set up the codebook in nettskjema, then turning this off will return the data as is.}

\item{checkbox_type}{string of either "string" (default), "list" or "columns" for how to handle checkbox answers}

\item{checkbox_delim}{delimiter string if \code{checkbox:type} is "string". Ignored else.}

\item{as_is}{logical. Whether to return the raw content from nettskjema. Default is FALSE.}

\item{from_date}{date. From which date on should data be fetched for}

\item{from_submission}{integer. From which SubmissionId should data be collected from.}

\item{incremental}{logical. False fetches all at once, TRUE fetches each submission individually. Slower but more stable for larger datasets.}

\item{token_name}{character. Name to give the token, defaults to 'NETTSKJEMA_API_TOKEN'}

\item{...}{arguments passed to \code{\link[httr]{GET}}}
}
\value{
tibble data.frame
}
\description{
This function connects to a specific form and fetches all answers.
The responses are placed in a data.frame for easy use.
For large data sets, toggle the \code{incremental} option,
which while slow, will be better able to retrieve all responses.
For retrieving responses only from a specific date on, or all responses
after a certain submission, use the \code{from_date} and \code{from_submission} arguments.
Forms that are anonymous and do not collect personal information do not record date,
and as such the \code{from_date} will not work on those and an error will be thrown.
}
\details{
Checkbox types
\itemize{
 \item{"string"}{ - returns a delimited character value per submission, where \code{checkbox_delim}
 denotes the options that the respondent has chosen}
 \item{"list"}{ - returns a list column, where each submission has a character vector with all the
 chosen options as separate elements in the list}
 \item{"columns"}{ - returns checkbox answers as separate binarized columns (column names are appended with
 response names), where 1 means the option was selected and 0 it was not.}
}
}
\examples{
\dontrun{

# Retrieve all data
data_110000 <- nettskjema_get_data(110000)
# Retrieve all data, and add answer order and option text
data_110000 <- nettskjema_get_data(110000, information = list(dummy = "order", text = "option"))

# Retrieve all data after a certain date
data_110000 <- nettskjema_get_data(110000, from_date = "2019-01-01")

# Retrieve all submissions after a specific submission id
data_110000 <- nettskjema_get_data(110000, from_submission = "12000000")

# For large data
data_110000 <- nettskjema_get_data(110000, incremental = TRUE)

}
}
