% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dominance.graph.R
\name{dominance_graph}
\alias{dominance_graph}
\title{Partial ranking as directed graph}
\usage{
dominance_graph(P)
}
\arguments{
\item{P}{A partial ranking as matrix object calculated with \link{neighborhood_inclusion}
or \link{positional_dominance}.}
}
\value{
Directed graph as an igraph object.
}
\description{
Turns a partial ranking into a directed graph. An edge (u,v) is
present if \code{P[u,v]=1}, meaning that u is dominated by v.
}
\examples{
library(igraph)
g <- threshold_graph(20, 0.1)
P <- neighborhood_inclusion(g)
d <- dominance_graph(P)
\dontrun{
plot(d)
}

# to reduce overplotting use transitive reduction
P <- transitive_reduction(P)
d <- dominance_graph(P)
\dontrun{
plot(d)
}
}
\author{
David Schoch
}
