% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rank.intervals.R
\name{plot_rank_intervals}
\alias{plot_rank_intervals}
\title{Plot rank intervals}
\usage{
plot_rank_intervals(P, cent.df = NULL, ties.method = "min")
}
\arguments{
\item{P}{A partial ranking as matrix object calculated with \link{neighborhood_inclusion}
or \link{positional_dominance}.}

\item{cent.df}{A data frame containing centrality scores of indices (optional). See Details.}

\item{ties.method}{String specifying how ties are treated in the base \code{\link[base]{rank}} function.}
}
\description{
This function is deprecated. Use \code{plot(rank_intervals(P))} instead
}
\examples{
library(igraph)
data("dbces11")
P <- neighborhood_inclusion(dbces11)
\dontrun{plot_rank_intervals(P)}

#adding index based rankings
cent_scores <- data.frame(
  degree = degree(dbces11),
  betweenness = round(betweenness(dbces11),4),
  closeness = round(closeness(dbces11),4),
  eigenvector = round(eigen_centrality(dbces11)$vector,4))
\dontrun{plot_rank_intervals(P,cent.df=cent_scores)}
}
\seealso{
\link{rank_intervals}
}
\author{
David Schoch
}
