% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperbolic.index.R
\name{hyperbolic_index}
\alias{hyperbolic_index}
\title{Hyperbolic (centrality) index}
\usage{
hyperbolic_index(g, type = "odd")
}
\arguments{
\item{g}{igraph object.}

\item{type}{string. 'even' if only even length walks should be considered. 'odd' (Default)
if only odd length walks should be used.}
}
\value{
A vector containing centrality scores.
}
\description{
The hyperbolic index is an index that considers all closed
walks of even or odd length on induced neighborhoods of a vertex.
}
\details{
The hyperbolic index is an illustrative index that should
not be used for any serious analysis. Its purpose is to show that with enough mathematical
trickery, any desired result can be obtained when centrality indices are used.
}
\examples{

library(igraph)

data("dbces11")
hyperbolic_index(dbces11,type = "odd")
hyperbolic_index(dbces11,type = "even")
}
\author{
David Schoch
}
