% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/positional.dominance.R
\name{positional_dominance}
\alias{positional_dominance}
\title{Generalized Dominance in Graphs}
\usage{
positional_dominance(A, type = "one-mode", map = FALSE, benefit = TRUE)
}
\arguments{
\item{A}{Matrix containing attributes or relations, for instance calculated by \link{indirect_relations}.}

\item{type}{A string which is either 'one-mode' (Default) if \code{A} is a regular one-mode network
or 'two-mode' if \code{A} is a general data matrix.}

\item{map}{Logical scalar, whether rows can be sorted or not (Default). See Details.}

\item{benefit}{Logical scalar, whether the attributes or relations are benefit or cost variables.}
}
\value{
Dominance relations as matrix object. An entry \code{[u,v]} is \code{1} if u is dominated by v.
}
\description{
generalized dominance relations.
}
\details{
Positional dominance is a generalization of neighborhood-inclusion for
arbitrary network data. In the default case, it checks for all pairs \eqn{u,v} if
\eqn{A_{ut} \ge A_{vt}} holds for all \eqn{t} if \code{benefit = TRUE} or
\eqn{A_{ut} \le A_{vt}} holds for all \eqn{t} if \code{benefit = FALSE}.
This form of dominance is referred to as \emph{dominance under total heterogeneity}.
If \code{map=TRUE}, the rows of \eqn{A} are sorted decreasingly (\code{benefit = TRUE})
or increasingly (\code{benefit = FALSE}) and then the dominance condition is checked. This second
form of dominance is referred to as \emph{dominance under total homogeneity}, while the
first is called \emph{dominance under total heterogeneity}.
}
\examples{
library(igraph)

g <- graph.empty(n=11,directed = FALSE)
g <- add_edges(g,c(1,11,2,4,3,5,3,11,4,8,5,9,5,11,6,7,6,8,
                   6,10,6,11,7,9,7,10,7,11,8,9,8,10,9,10))
P<-neighborhood_inclusion(g)
comparable_pairs(P)

# positional dominance under total heterogeneity
dist <- indirect_relations(g,type = "dist_sp")
D <- positional_dominance(dist,map = FALSE,benefit = FALSE) 
comparable_pairs(D) 

# positional dominance under total homogeneity
D_map <- positional_dominance(dist,map = TRUE,benefit = FALSE) 
comparable_pairs(D_map) #more comparables than D

}
\references{
Brandes, U., 2016. Network positions. \emph{Methodological Innovations} 9,
2059799116630650.

Schoch, D. and Brandes, U., 2016. Re-conceptualizing centrality in social networks.
\emph{European Journal of Applied Mathematics} 27(6), 971-985.
}
\seealso{
\link{neighborhood_inclusion}, \link{indirect_relations}, \link{exact_rank_prob}
}
\author{
David Schoch
}
