% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_netmhc2pan_from_files.R
\name{install_netmhc2pan_from_files}
\alias{install_netmhc2pan_from_files}
\title{Install NetMHCIIpan from files.}
\usage{
install_netmhc2pan_from_files(
  netmhc2pan_bin_tarfile_path,
  netmhc2pan_data_tarfile_path,
  verbose = FALSE,
  netmhc2pan_archive_filename = get_netmhc2pan_archive_filename(),
  netmhc2pan_folder_name = get_default_netmhc2pan_folder(),
  temp_local_file = tempfile(pattern = "netmhc2pan_install_netmhc2pan_")
)
}
\arguments{
\item{netmhc2pan_bin_tarfile_path}{path of the
NetMHCIIpan binary tarball file}

\item{netmhc2pan_data_tarfile_path}{path of the
NetMHCIIpan data tarball file}

\item{verbose}{set to TRUE for more output}

\item{netmhc2pan_archive_filename}{the NetMHC2pan archive
filename, for example \code{netMHCIIpan-3.2.Linux.tar.gz},
which is used in installation of NetMHC2pan.
Use \link{get_netmhc2pan_archive_filename} to get this filename.}

\item{netmhc2pan_folder_name}{the folder (to be) used by NetMHCIIpan.
From this location, a subfolder for NetMHCIIpan is created.
Use \link{get_default_netmhc2pan_folder} to see the location
of the default NetMHCIIpan folder.
Use \link{get_default_netmhc2pan_subfolder} to see the location
of the default NetMHCIIpan subfolder.}

\item{temp_local_file}{path to the temporary file to store the URL to.
This file will be deleted afterwards.}
}
\value{
Nothing
}
\description{
Install NetMHCIIpan to a local folder from (already downloaded)
binary and date tarball files.
Use \link{install_netmhc2pan} to install
NetMHCIIpan by downloading these files
}
\details{
These are three steps:

\itemize{
  \item Install the NetMHCIIpan binary,
    using \link{install_netmhc2pan_bin_from_file}
  \item Install the NetMHCIIpan data,
    using \link{install_netmhc2pan_data_from_file}
  \item Set up NetMHCIIpan, using \link{set_up_netmhc2pan}
}
}
\author{
Richèl J.C. Bilderbeek
}
