% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.rankogram.R
\name{summary.rankogram}
\alias{summary.rankogram}
\alias{print.summary.rankogram}
\title{Summary method for objects of class rankogram}
\usage{
\method{summary}{rankogram}(object, ...)

\method{print}{summary.rankogram}(
  x,
  common = x$common,
  random = x$random,
  sort = TRUE,
  nchar.trts = x$nchar.trts,
  digits = gs("digits.prop"),
  digits.mean = 2,
  details.methods = gs("details"),
  legend = gs("legend"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{rankogram}.}

\item{\dots}{Additional arguments (passed on to
\code{\link{print.rankogram}}.}

\item{x}{An object of class \code{summary.rankogram}.}

\item{common}{A logical indicating to print ranking probabilities
and SUCRAs for the common effects model.}

\item{random}{A logical indicating to print ranking probabilities
and SUCRAs for the random effects model.}

\item{sort}{A logical indicating whether treatments should be
sorted by decreasing SUCRAs.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names.}

\item{digits}{Minimal number of significant digits for ranking probabilities
and SUCRAs, see \code{\link{print.default}}.}

\item{digits.mean}{Minimal number of significant digits for mean ranks, see
\code{\link{print.default}}.}

\item{details.methods}{A logical specifying whether details on statistical
methods should be printed.}

\item{legend}{A logical indicating whether a legend should be
printed.}
}
\description{
Summary method for objects of class \code{rankogram} to print
list of studies in subnetworks.
}
\examples{
# Examples:
# example(rankogram.netmeta)

}
\seealso{
\code{\link{rankogram}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
