% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.pairwise.R
\name{merge.pairwise}
\alias{merge.pairwise}
\title{Merge pairwise object with additional data}
\usage{
\method{merge}{pairwise}(x, y, all.x = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{pairwise}.}

\item{y}{A data frame or an object of class \code{netconnection}.}

\item{all.x}{A logical indicating whether to keep all observations from the
pairwise object, i.e., also include observations not belonging to a
subnetwork due to missing estimates or standard errors.}

\item{\dots}{Other arguments (passed on to \code{merge}).}
}
\value{
An object of class \code{pairwise}.
}
\description{
Merge pairwise object with additional data, e.g., information on
network connectivity.
}
\examples{
# Transform data from long arm-based format to contrast-based
# format Argument 'sm' has to be used for odds ratio as summary
# measure; by default the risk ratio is used in the metabin
# function called internally.
#
pw1 <- pairwise(treatment, event = r, n = N,
  studlab = author, data = dat.woods2010, sm = "OR")
head(pw1)

# Add information on network connectivity
nc1 <- netconnection(pw1)
pw1nc1 <- merge(pw1, nc1)
head(pw1nc1)

}
\seealso{
\code{\link[meta]{pairwise}}, \code{\link{netconnection}},
  \code{\link[metadat]{dat.woods2010}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
