% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netmap_plot.R
\name{network.layout.extract_coordinates}
\alias{network.layout.extract_coordinates}
\title{Layout of a network based on a \code{sf} object}
\usage{
network.layout.extract_coordinates(n, layout.par)
}
\arguments{
\item{n}{A \code{network} or \code{igraph} object. Not used, only for
compatibility with \code{\link[network]{plot.network}}.}

\item{layout.par}{A \code{list} of layout parameters (the only one implemented is
\code{layout.par$sf}, an \code{sf} object whose rows match the order of
vertices in \code{n}).}
}
\value{
A matrix whose rows contain the x,y coordinates of the vertices of \code{n}.
}
\description{
Custom layout for \code{\link[network]{plot.network}}, extracting coordinates
of vertices from a \code{sf} object. Its result can be used by
\code{\link[igraph]{plot.igraph}} as well.
}
\examples{
net=network::network(matrix(c(0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0), nrow=4, byrow=TRUE))
network::set.vertex.attribute(net, "name", value=c("a", "b", "c", "d"))
wkb = structure(list("01010000204071000000000000801A064100000000AC5C1641",
"01010000204071000000000000801A084100000000AC5C1441",
"01010000204071000000000000801A044100000000AC5C1241",
"01010000204071000000000000801A024100000000AC5C1841"), class = "WKB")
map=sf::st_sf(id=c("a1", "b2", "c3", "d4"), sf::st_as_sfc(wkb, EWKB=TRUE))
lkptbl=data.frame(id=c("a1", "b2", "c3", "d4"), name=c("a", "b", "c", "d"))
netmap::network.layout.extract_coordinates(net, list(sf=map))
}
