% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_apply.R
\name{diff_test}
\alias{diff_test}
\title{Test for differences from original statistic}
\usage{
diff_test(netSampleStatSet, p.adjust = "BH", non.parametric = F)
}
\arguments{
\item{netSampleStatSet}{Input \code{NetSampleStatSet}}

\item{p.adjust}{character string for requested multiple comparisons
adjustment. Defaults to Benjamani-Hochberg}

\item{non.parametric}{Logical. if true, test is performed using Wilcox test.
If false, t-test. Defaults to false.}
}
\value{
A data frame containing original and adjusted p.values, as well as
  differences, labeled with manipulation name.
}
\description{
This function tests for significant differences from the original network
statistic as a result of the network manipulation. If non-parametric is
chosen, this is done using the Wilcox test, otherwise, t-test.
}
\examples{
data(GroupA)
GroupA_Net = as_NetSample(GroupA, 1:20, node.variables = list(community = c(rep(1, 10), rep(2,10))),
  sample.variables = list(group = c(rep(1, 10), rep(2,10))))
Jackknife_GroupA_Net = net_apply(GroupA_Net, node_jackknife)
GlobEff_GroupA_Net = net_stat_apply(Jackknife_GroupA_Net, global_efficiency)
diff_test(GlobEff_GroupA_Net)
}
