% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/stats.R
\name{vertex_covariate_dist}
\alias{vertex_covariate_dist}
\alias{vertex_covariate_dist}
\alias{p-norm}
\alias{mahalanobis}
\alias{vertex_mahalanobis_dist}
\title{Computes covariate distance between connected vertices}
\usage{
vertex_covariate_dist(graph, X, p = 2)

vertex_mahalanobis_dist(graph, X, S)
}
\arguments{
\item{graph}{A square matrix of size \eqn{n} of class dgCMatrix.}

\item{X}{A numeric matrix of size \eqn{n \times K}{n * K}. Vertices attributes}

\item{p}{Numeric scalar. Norm to compute}

\item{S}{Square matrix of size \code{ncol(x)}. Usually the var-covar matrix.}
}
\value{
A matrix of size \eqn{n\times n}{n * n} of class \code{dgCMatrix}. Will
be symmetric only if \code{graph} is symmetric.
}
\description{
Computes covariate distance between connected vertices
}
\details{
Faster than \code{\link{dist}}, these functions compute distance metrics
between pairs of vertices that are connected (otherwise skip).

The function \code{vertex_covariate_dist} is the simil of \code{\link{dist}}
and returns p-norms. It is implemented as follows (for each pair of vertices):

\deqn{%
D_{ij} = \left(\sum_{k=1}^K (X_{ik} - X_{jk})^{p} \right)^{1/p}\mbox{ if }graph_{i,j}\neq 0
}{%
D(i,j) = [\sum_k (X(i,k) - X(j,k))^p]^(1/p)  if graph(i,j) != 0
}

In the case of mahalanobis distance, for each pair of vertex \eqn{(i,j)}, the
distance is computed as follows:

\deqn{%
D_{ij} = \left( (X_i - X_j)\times S \times (X_i - X_j)' \right)^{1/2}\mbox{ if }graph_{i,j}\neq 0
}{%
D(i,j) = sqrt[(X(i) - X(j)) \%*\% S  \%*\% t(X(i) - X(j))]  if graph(i,j) != 0
}
}
\examples{
# Distance (aka p norm) -----------------------------------------------------
set.seed(123)
G <- rgraph_ws(20, 4, .1)
X <- matrix(runif(40), ncol=2)

vertex_covariate_dist(G, X)

# Mahalanobis distance ------------------------------------------------------
S <- var(X)

M <- vertex_mahalanobis_dist(G, X, S)

# Example with diffnet objects ----------------------------------------------

data(medInnovationsDiffNet)
X <- cbind(
  medInnovationsDiffNet[["proage"]],
  medInnovationsDiffNet[["attend"]]
)

S <- var(X, na.rm=TRUE)
ans <- vertex_mahalanobis_dist(medInnovationsDiffNet, X, S)

}
\references{
Mahalanobis distance. (2016, September 27). In Wikipedia, The Free Encyclopedia.
Retrieved 20:31, September 27, 2016, from
\url{https://en.wikipedia.org/w/index.php?title=Mahalanobis_distance&oldid=741488252}
}
\seealso{
\code{\link[stats:mahalanobis]{mahalanobis}} in the stats package.

Other statistics: \code{\link{bass}},
  \code{\link{classify_adopters}},
  \code{\link{cumulative_adopt_count}}, \code{\link{dgr}},
  \code{\link{ego_variance}}, \code{\link{exposure}},
  \code{\link{hazard_rate}}, \code{\link{infection}},
  \code{\link{moran}}, \code{\link{struct_equiv}},
  \code{\link{threshold}}
}
\author{
George G. Vega Yon
}
