# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

toa_mat_cpp <- function(year, t0, t1) {
    .Call('netdiffuseR_toa_mat_cpp', PACKAGE = 'netdiffuseR', year, t0, t1)
}

edgelist_to_adjmat_cpp <- function(edgelist, weights = as.numeric( c()), n = 0L, undirected = FALSE, self = FALSE, multiple = FALSE) {
    .Call('netdiffuseR_edgelist_to_adjmat_cpp', PACKAGE = 'netdiffuseR', edgelist, weights, n, undirected, self, multiple)
}

adjmat_to_edgelist_cpp <- function(adjmat, undirected = TRUE) {
    .Call('netdiffuseR_adjmat_to_edgelist_cpp', PACKAGE = 'netdiffuseR', adjmat, undirected)
}

toa_diff_cpp <- function(year) {
    .Call('netdiffuseR_toa_diff_cpp', PACKAGE = 'netdiffuseR', year)
}

isolated_cpp <- function(adjmat, undirected = TRUE) {
    .Call('netdiffuseR_isolated_cpp', PACKAGE = 'netdiffuseR', adjmat, undirected)
}

drop_isolated_cpp <- function(adjmat, isolated, undirected = TRUE) {
    .Call('netdiffuseR_drop_isolated_cpp', PACKAGE = 'netdiffuseR', adjmat, isolated, undirected)
}

egonet_attrs_cpp <- function(graph, V, outer = TRUE, self = TRUE, valued = TRUE) {
    .Call('netdiffuseR_egonet_attrs_cpp', PACKAGE = 'netdiffuseR', graph, V, outer, self, valued)
}

infection_cpp <- function(graph, times, normalize = TRUE, K = 1L, r = 0.5, expdiscount = FALSE, n = 0L, valued = FALSE, outgoing = TRUE) {
    .Call('netdiffuseR_infection_cpp', PACKAGE = 'netdiffuseR', graph, times, normalize, K, r, expdiscount, n, valued, outgoing)
}

susceptibility_cpp <- function(graph, times, normalize = TRUE, K = 1L, r = 0.5, expdiscount = FALSE, n = 0L, valued = FALSE, outgoing = TRUE) {
    .Call('netdiffuseR_susceptibility_cpp', PACKAGE = 'netdiffuseR', graph, times, normalize, K, r, expdiscount, n, valued, outgoing)
}

moran_cpp <- function(x, w) {
    .Call('netdiffuseR_moran_cpp', PACKAGE = 'netdiffuseR', x, w)
}

sparse_indexes <- function(mat) {
    .Call('netdiffuseR_sparse_indexes', PACKAGE = 'netdiffuseR', mat)
}

angle <- function(x0, y0, x1, y1) {
    .Call('netdiffuseR_angle', PACKAGE = 'netdiffuseR', x0, y0, x1, y1)
}

sp_trimatl <- function(x) {
    .Call('netdiffuseR_sp_trimatl', PACKAGE = 'netdiffuseR', x)
}

sp_diag <- function(x, v) {
    .Call('netdiffuseR_sp_diag', PACKAGE = 'netdiffuseR', x, v)
}

unif_rand_w_exclusion <- function(n, e) {
    .Call('netdiffuseR_unif_rand_w_exclusion', PACKAGE = 'netdiffuseR', n, e)
}

#' Distribution over a grid
#'
#' Distribution of pairs over a grid of fix size.
#'
#' @param x Numeric vector of size \eqn{n}
#' @param y Numeric vector of size \eqn{n}
#' @param nlevels Integer scalar. Number of bins to return
#' @details
#'
#' This function ment for internal use only.
#'
#' @export
#' @keywords misc dplot
#' @seealso Used by \code{\link{plot_infectsuscep}}
#' @return Returns a list with three elements
#' \item{x}{Numeric vector of size \code{nlevels} with the class marks for x}
#' \item{y}{Numeric vector of size \code{nlevels} with the class marks for y}
#' \item{z}{Numeric matrix of size \code{nlevels} by \code{nlevels} with the distribution %
#' of the elements in terms of frecuency}
#' @section Examples:
#' \preformatted{
#' # Generating random vectors of size 100
#' x <- rnorm(100)
#' y <- rnorm(100)
#'
#' # Calculating distribution
#' grid_distribution(x,y,20)
#' }
grid_distribution <- function(x, y, nlevels = 100L) {
    .Call('netdiffuseR_grid_distribution', PACKAGE = 'netdiffuseR', x, y, nlevels)
}

#' Compute ego/alter edge coordinates considering alter's size and aspect ratio
#'
#' Given a graph, vertices' positions and sizes, calculates the absolute positions
#' of the endpoints of the edges considering the plot's aspect ratio.
#'
#' @param graph A square matrix of size \eqn{n}. Adjacency matrix.
#' @param toa Integer vector of size \eqn{n}. Times of adoption.
#' @param x Numeric vector of size \eqn{n}. x-coordinta of vertices.
#' @param y Numeric vector of size \eqn{n}. y-coordinta of vertices.
#' @param vertex_cex Numeric vector of size \eqn{n}. Vertices' sizes in terms
#' of the x-axis (see \code{\link{symbols}}).
#' @param undirected Logical scalar. Whether the graph is undirected or not.
#' @param no_contemporary Logical scalar. Whether to return (calcular) edges'
#' coordiantes for vertices with the same time of adoption (see details).
#' @param dev Numeric vector of size 2. Height and width of the device (see details).
#' @param ran Numeric vector of size 2. Range of the x and y axis (see details).
#' @return A numeric matrix of size \eqn{m\times 5}{m * 5} with the following
#' columns:
#' \item{x0, y0}{Edge origin}
#' \item{x1, y1}{Edge target}
#' \item{alpha}{Relative angle between \code{(x0,y0)} and \code{(x1,y1)} in terms
#' of radians}
#' With \eqn{m} as the number of resulting edges.
#' @details
#'
#' In order to make the plot's visualization more appealing, this function provides
#' a straight forward way of computing the tips of the edges considering the
#' aspect ratio of the axes range. In particular, the following corrections are
#' made at the moment of calculating the egdes coords:
#'
#' \itemize{
#' \item{Instead of using the actual distance between ego and alter, a relative
#' one is calculated as follows
#' \deqn{d'=\left[(x_0-x_1)^2 + (y_0' - y_1')^2\right]^\frac{1}{2}}{d'=sqrt[(x0-x1)^2 + (y0'-y1')^2]}
#' where \eqn{%
#' y_i'=y_i\times\frac{\max x - \min x}{\max y - \min y} }{%
#' yi' = yi * [max(x) - min(x)]/[max(y) - min(y)]}
#' }
#' \item{Then, for the relative elevation angle, \code{alpha}, the relative distance \eqn{d'}
#' is used, \eqn{\alpha'=\arccos\left( (x_0 - x_1)/d' \right)}{\alpha' = acos[ (x0 - x1)/d' ]}}
#' \item{Finally, the edge's endpoint's (alter) coordinates are computed as follows: %
#' \deqn{%
#'   x_1' = x_1 + \cos(\alpha')\times v_1}{%
#'   x1' = x1 + cos(\alpha') * v1
#' }
#' \deqn{%
#'   y_1' = y_1 -+ \sin(\alpha')\times v_1 \times\frac{\max y - \min y}{\max x - \min x} }{%
#'   y1' = y1 -+ sin(\alpha')*[max(y) - min(y)]/[max(x) - min(x)]
#' }
#' Where \eqn{v_1}{v1} is alter's size in terms of the x-axis, and the sign of
#' the second term in \eqn{y_1'}{y1'} is negative iff \eqn{y_0 < y_1}{y0<y1}.
#' }
#' }
#'
#' The same process (with sign inverted) is applied to the edge starting piont.
#' The resulting values, \eqn{x_1',y_1'}{x1',y1'} can be used with the function
#' \code{\link{arrows}}. This is the workhorse function used in \code{\link{plot_threshold}}.
#'
#' The \code{dev} argument provides a reference to rescale the plot accordingly
#' to the device, and former, considering the size of the margins as well (this
#' can be easily fetched via \code{par("pin")}, plot area in inches).
#'
#' On the other hand, \code{ran} provides a reference for the adjustment
#' according to the range of the data, this is \code{range(x)[2] - range(x)[1]}
#' and \code{range(y)[2] - range(y)[1]} respectively.
#'
#' @keywords misc dplot
#' @examples
#' # --------------------------------------------------------------------------
#' data(medInnovationsDiffNet)
#' library(sna)
#'
#' # Computing coordinates
#' set.seed(79)
#' coords <- sna::gplot(as.matrix(medInnovationsDiffNet$graph[[1]]))
#'
#' # Getting edge coordinates
#' vcex <- rep(1.5, nnodes(medInnovationsDiffNet))
#' ecoords <- edges_coords(
#'   medInnovationsDiffNet$graph[[1]],
#'   diffnet.toa(medInnovationsDiffNet),
#'   x = coords[,1], y = coords[,2],
#'   vertex_cex = vcex,
#'   dev = par("pin")
#'   )
#'
#' ecoords <- as.data.frame(ecoords)
#'
#' # Plotting
#' symbols(coords[,1], coords[,2], circles=vcex,
#'   inches=FALSE, xaxs="i", yaxs="i")
#'
#' with(ecoords, arrows(x0,y0,x1,y1, length=.1))
#' @export
edges_coords <- function(graph, toa, x, y, vertex_cex, undirected = TRUE, no_contemporary = TRUE, dev = as.numeric( c()), ran = as.numeric( c())) {
    .Call('netdiffuseR_edges_coords', PACKAGE = 'netdiffuseR', graph, toa, x, y, vertex_cex, undirected, no_contemporary, dev, ran)
}

edges_arrow <- function(x0, y0, x1, y1, height, width, beta = 1.5707963267949, dev = as.numeric( c()), ran = as.numeric( c())) {
    .Call('netdiffuseR_edges_arrow', PACKAGE = 'netdiffuseR', x0, y0, x1, y1, height, width, beta, dev, ran)
}

vertices_coords <- function(x, y, size, nsides, rot, dev = as.numeric( c()), ran = as.numeric( c())) {
    .Call('netdiffuseR_vertices_coords', PACKAGE = 'netdiffuseR', x, y, size, nsides, rot, dev, ran)
}

rewire_swap <- function(graph, nsteps = 100L, self = FALSE, multiple = FALSE, undirected = FALSE) {
    .Call('netdiffuseR_rewire_swap', PACKAGE = 'netdiffuseR', graph, nsteps, self, multiple, undirected)
}

rgraph_ba_cpp <- function(graph, dgr, m = 1L, t = 10L) {
    .Call('netdiffuseR_rgraph_ba_cpp', PACKAGE = 'netdiffuseR', graph, dgr, m, t)
}

rgraph_ba_new_cpp <- function(m0 = 1L, m = 1L, t = 10L) {
    .Call('netdiffuseR_rgraph_ba_new_cpp', PACKAGE = 'netdiffuseR', m0, m, t)
}

rgraph_er_cpp <- function(n = 10L, p = 0.3, undirected = TRUE, weighted = FALSE, self = FALSE) {
    .Call('netdiffuseR_rgraph_er_cpp', PACKAGE = 'netdiffuseR', n, p, undirected, weighted, self)
}

rgraph_er_dyn_cpp <- function(n = 10L, t = 3L, p = 0.3, undirected = TRUE, weighted = FALSE, self = FALSE) {
    .Call('netdiffuseR_rgraph_er_dyn_cpp', PACKAGE = 'netdiffuseR', n, t, p, undirected, weighted, self)
}

#' Ring lattice graph
#'
#' Creates a ring lattice with \eqn{n} vertices, each one of degree (at most) \eqn{k}
#' as an undirected graph. This is the basis of \code{\link{rgraph_ws}}.
#' @param n Integer scalar. Size of the graph.
#' @param k Integer scalar. Out-degree of each vertex.
#' @param undirected Logical scalar. Whether the graph is undirected or not.
#' @details when \code{undirected=TRUE}, the degree of each node always
#' even. So if \code{k=3}, then the degree will be \code{2}.
#' @return A sparse matrix of class \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}} of size
#' \eqn{n\times n}{n * n}.
#' @references Watts, D. J., & Strogatz, S. H. (1998). Collective dynamics of
#' “small-world” networks. Nature, 393(6684), 440–2. \url{http://doi.org/10.1038/30918}
#' @export
#' @family simulation functions
ring_lattice <- function(n, k, undirected = FALSE) {
    .Call('netdiffuseR_ring_lattice', PACKAGE = 'netdiffuseR', n, k, undirected)
}

rewire_endpoints <- function(graph, p, both_ends = FALSE, self = FALSE, multiple = FALSE, undirected = FALSE) {
    .Call('netdiffuseR_rewire_endpoints', PACKAGE = 'netdiffuseR', graph, p, both_ends, self, multiple, undirected)
}

rewire_ws <- function(G, K, p = 0.0, self = FALSE, multiple = FALSE) {
    .Call('netdiffuseR_rewire_ws', PACKAGE = 'netdiffuseR', G, K, p, self, multiple)
}

select_egoalter_cpp <- function(adjmat_t0, adjmat_t1, adopt_t0, adopt_t1) {
    .Call('netdiffuseR_select_egoalter_cpp', PACKAGE = 'netdiffuseR', adjmat_t0, adjmat_t1, adopt_t0, adopt_t1)
}

degree_cpp <- function(adjmat0, cmode = 2L, undirected = TRUE, self = FALSE, valued = FALSE) {
    .Call('netdiffuseR_degree_cpp', PACKAGE = 'netdiffuseR', adjmat0, cmode, undirected, self, valued)
}

exposure_cpp <- function(graph, cumadopt, attrs, outgoing = TRUE, valued = TRUE, normalized = TRUE) {
    .Call('netdiffuseR_exposure_cpp', PACKAGE = 'netdiffuseR', graph, cumadopt, attrs, outgoing, valued, normalized)
}

cumulative_adopt_count_cpp <- function(cumadopt) {
    .Call('netdiffuseR_cumulative_adopt_count_cpp', PACKAGE = 'netdiffuseR', cumadopt)
}

hazard_rate_cpp <- function(cumadopt) {
    .Call('netdiffuseR_hazard_rate_cpp', PACKAGE = 'netdiffuseR', cumadopt)
}

threshold_cpp <- function(exposure, toa, include_censored = FALSE) {
    .Call('netdiffuseR_threshold_cpp', PACKAGE = 'netdiffuseR', exposure, toa, include_censored)
}

struct_equiv_cpp <- function(graph, v = 1.0, unscaled = FALSE, inv = FALSE, invrep = 0.0) {
    .Call('netdiffuseR_struct_equiv_cpp', PACKAGE = 'netdiffuseR', graph, v, unscaled, inv, invrep)
}

