% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stir_NM.R
\name{stir_NM}
\alias{stir_NM}
\title{Stirs a Niche Model Network}
\usage{
stir_NM(matrix, x, niches, directed = TRUE, connectance = 0.2)
}
\arguments{
\item{matrix}{Existing network to experience rewiring (stirring).}

\item{x}{The ID of the node to be grown.}

\item{niches}{Vector of length x, with values between zero and one corresponding to each node's niche.}

\item{directed}{Binary variable determining if the network is directed, resulting in off-diagonal asymmetry in the adjacency matrix. Defaults to TRUE.}

\item{connectance}{Niche Model parameter specifying the expected connectivity of the network, which determines for a given node the niche space window within which it attaches to every other node. Defaults to 0.2.}
}
\value{
An adjacency matrix.
}
\description{
Stirs an already existing network by rewiring a node according to the Niche Model mechanism.
}
\details{
Stirs a node in a Niche Model network.
}
\examples{
# Import netcom
library(netcom)

size <- 10
existing_network <- matrix(sample(c(0,1), size = size^2, replace = TRUE), nrow = size, ncol = size)
new_network_prep <- matrix(0, nrow = size + 1, ncol = size + 1)
new_network_prep[1:size, 1:size] = existing_network
new_network <- stir_NM(
     matrix = new_network_prep, 
     x = size + 1, 
     connectance = 0.1, 
     niches = runif(size + 1)
)

}
\references{
Williams, R. J., & Martinez, N. D. (2000). Simple rules yield complex food webs. Nature, 404(6774), 180-183.
}
