% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chaingibbs.R
\name{chaingibbs}
\alias{chaingibbs}
\title{Generate Gibbs samplers for counterfactual collective outcomes.}
\usage{
chaingibbs(pars, n.obs, treatment, covariates, initprob = 0.5,
  yvalues = c(0, 1), Neighborind, Neighborpar, n.burn)
}
\arguments{
\item{pars}{a set of parameters}

\item{n.obs}{the number of Gibbs samples.}

\item{treatment}{a set of given treatment assignment of length \code{m}.}

\item{covariates}{given confounder(s):
\itemize{
\item{\code{NULL}}{: no confounder.}
\item{a vector of length \code{m}}{: under unique confounder.}
\item{a \code{[q x m]} matrix}{: a set of \code{q} different confounders.}
}}

\item{initprob}{an initial probability generating outcomes. Defaults to \code{initprob} = 0.5}

\item{yvalues}{distinct binary values for outcomes. Defaults to \code{(0,1)}.}

\item{Neighborind}{a list of matrix specifying edge information of which first column illustrates a type of variables (1:outcome, 2:treatment, 3~:confounders) and of which second column presents the index of those variable.}

\item{Neighborpar}{index for parameters in the order of Neighborind.}

\item{n.burn}{the number of burn-in sample in Gibbs sampling (\eqn{\ge} \code{n.obs}).}
}
\value{
a \code{[n.obs x m]} matrix each row of which consists of outcomes.
}
\description{
This function generates the outcomes using Gibbs sampling under the given treatment assignment
and edge information.
}
