% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{augment.nested_model_fit}
\alias{augment.nested_model_fit}
\title{Augment data with predictions}
\usage{
\method{augment}{nested_model_fit}(x, new_data, ...)
}
\arguments{
\item{x}{A \code{nested_model_fit} object produced by
\code{\link[=fit.nested_model]{fit.nested_model()}}.}

\item{new_data}{A data frame - can be nested or non-nested.}

\item{...}{Passed onto \code{\link[parsnip:augment]{parsnip::augment.model_fit()}}.}
}
\value{
A data frame with one or more added columns for predictions.
}
\description{
\code{\link[generics:augment]{generics::augment()}} method for nested models. \code{augment.nested_model_fit()}
will add column(s) for predictions to the given data.
}
\examples{

library(dplyr)
library(tidyr)
library(parsnip)

data <- filter(example_nested_data, id \%in\% 1:5)

nested_data <- nest(data, data = -c(id, id2))

model <- linear_reg() \%>\%
  set_engine("lm") \%>\%
  nested()

fitted <- fit(model, z ~ x + y + a + b, nested_data)

augment(fitted, example_nested_data)

}
\seealso{
\code{\link[parsnip:augment]{parsnip::augment.model_fit()}}
}
