% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trauma_03_population.R
\name{trauma_03_population}
\alias{trauma_03_population}
\title{Trauma-03 Populations}
\usage{
trauma_03_population(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  disposition_table = NULL,
  vitals_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  esituation_02_col,
  eresponse_05_col,
  evitals_01_col,
  evitals_27_col = NULL,
  evitals_27_initial_col = NULL,
  evitals_27_last_col = NULL,
  edisposition_28_col,
  transport_disposition_col
)
}
\arguments{
\item{df}{A data frame or tibble containing EMS data with all relevant
columns. Default is \code{NULL}.}

\item{patient_scene_table}{A data frame or tibble containing only epatient
and escene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data frame or tibble containing only the eresponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{situation_table}{A data frame or tibble containing only the esituation
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{disposition_table}{A data frame or tibble containing only the
edisposition fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{vitals_table}{A data frame or tibble containing only the evitals fields
needed for this measure's calculations. Default is \code{NULL}.}

\item{erecord_01_col}{The column representing the EMS record unique
identifier.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{The column for patient age numeric value.}

\item{epatient_16_col}{The column for patient age unit (e.g., "Years",
"Months").}

\item{esituation_02_col}{The column containing information on the presence of
injury.}

\item{eresponse_05_col}{The column representing the 911 response type.}

\item{evitals_01_col}{The column for the time of pain scale measurement.}

\item{evitals_27_col}{The column for the pain scale score. Default is \code{NULL}.}

\item{evitals_27_initial_col}{The column for the initial pain scale score.
Default is \code{NULL}.}

\item{evitals_27_last_col}{The column for the last pain scale score. Default
is \code{NULL}.}

\item{edisposition_28_col}{The column for patient care disposition details.}

\item{transport_disposition_col}{The column for patient transport
disposition.}
}
\value{
A list that contains the following:
\itemize{
\item a tibble with counts for each filtering step,
\item a tibble for each population of interest
\item a tibble for the initial population
\item a tibble for the total dataset with computations
}
}
\description{
Filters data down to the target populations for Trauma-08, and categorizes
records to identify needed information for the calculations.

Identifies key categories to records that are 911 request for patients whose
pain score was lowered during the EMS encounter. based on specific criteria
and calculates related ECG measures. This function segments the data by age
into adult and pediatric populations.
}
\examples{

# create tables to test correct functioning

  # patient table
  patient_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    incident_date = as.Date(c("2025-01-01", "2025-01-05",
                              "2025-02-01", "2025-01-01",
                              "2025-06-01")
                              ),
    patient_dob = as.Date(c("2000-01-01", "2020-01-01",
                            "2023-02-01", "2023-01-01",
                            "1970-06-01")
                            ),
    epatient_15 = c(25, 5, 2, 2, 55),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Years", "Years")

  )

  # response table
  response_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    eresponse_05 = rep(2205001, 5)

  )

  # situation table
  situation_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    esituation_02 = rep("Yes", 5),
  )

  # vitals table for a single pain scale column
  vitals_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    evitals_01 = lubridate::as_datetime(c("2025-01-01 12:00:00", "2025-01-05
    18:00:00", "2025-02-01 06:00:00", "2025-01-01 01:00:00", "2025-06-01
    14:00:00"))
  ) |>
    tidyr::uncount(weights = 2) |>  # Duplicate each row twice
    # Assign pain scores
    dplyr::mutate(evitals_27 = c(0, 0, 2, 1, 4, 3, 6, 5, 8, 7)) |>
    dplyr::group_by(erecord_01) |>
    dplyr::mutate(
    # Lower score = later time
      time_offset = dplyr::if_else(dplyr::row_number() == 1, -5, 0),
      evitals_01 = evitals_01 + lubridate::dminutes(time_offset)
    ) |>
    dplyr::ungroup() |>
    dplyr::select(-time_offset)  # Remove temporary column

  # disposition table
  disposition_table <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    edisposition_28 = rep(4228001, 5),
    edisposition_30 = c(4230001, 4230003, 4230001, 4230007, 4230007)
  )

# test the success of the function
# use the single pain scale column
  result <- trauma_03_population(patient_scene_table = patient_table,
                        response_table = response_table,
                        situation_table = situation_table,
                        vitals_table = vitals_table,
                        disposition_table = disposition_table,
                        erecord_01_col = erecord_01,
                        incident_date_col = incident_date,
                        patient_DOB_col = patient_dob,
                        epatient_15_col = epatient_15,
                        epatient_16_col = epatient_16,
                        eresponse_05_col = eresponse_05,
                        esituation_02_col = esituation_02,
                        evitals_01_col = evitals_01,
                        evitals_27_initial_col = NULL,
                        evitals_27_last_col = NULL,
                        evitals_27_col = evitals_27,
                        edisposition_28_col = edisposition_28,
                        transport_disposition_col = edisposition_30
                        )

# show the results of filtering at each step
result$filter_process

}
\author{
Nicolas Foss, Ed.D., MS
}
