################################################
#
# Test script for neatRanges - partition_ranges
#
# Last updated on 07/04/2019
#
################################################
context("partition_ranges")

test_that("partition_ranges is functional when partitioning by year", {

  df <- data.frame(group = c("a", "a", "b", "b", "c"),
                   start = c("2017-05-01", "2019-04-03", "2011-03-03", "2014-05-07", "2017-02-01"),
                   end = c("2018-09-01", "2020-04-03", "2012-05-03", "2016-04-02", "2017-04-05")
  )

  output <-
    structure(
      list(
        group = structure(
          c(1L, 1L, 1L, 1L, 2L, 2L, 2L,
            2L, 2L, 3L),
          .Label = c("a", "b", "c"),
          class = "factor"
        ),
        start = structure(
          c(
            17287,
            17532,
            17989,
            18262,
            15036,
            15340,
            16197,
            16436,
            16801,
            17198
          ),
          class = "Date"
        ),
        end = structure(
          c(
            17531,
            17775,
            18261,
            18355,
            15339,
            15463,
            16435,
            16800,
            16893,
            17261
          ),
          class = "Date"
        )
      ),
      class = "data.frame",
      row.names = c(NA,-10L)
    )

  output_foo <- partition_ranges(df, "start", "end")

  expect_equal(output, output_foo)

}

)

test_that("partition_ranges is functional when partitioning by month", {

  df <- data.frame(group = c("a", "a", "b", "b", "c", "d", "d"),
                   start = c("2017-05-01", "2019-04-03", "2011-03-03", "2014-05-07", "2017-02-01", "2018-01-01", "2019-01-01"),
                   end = c("2018-09-01", "2020-04-03", "2012-05-03", "2016-04-02", "2017-04-05", "2018-01-30", "2019-03-05")
  )

  output <- structure(list(group = structure(c(1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                               1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                               1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
                                               2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
                                               2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 3L,
                                               3L, 4L, 4L, 4L, 4L), .Label = c("a", "b", "c", "d"), class = "factor"),
                           start = structure(c(17287, 17318, 17348, 17379, 17410, 17440,
                                               17471, 17501, 17532, 17563, 17591, 17622, 17652, 17683, 17713,
                                               17744, 17775, 17989, 18017, 18048, 18078, 18109, 18140, 18170,
                                               18201, 18231, 18262, 18293, 18322, 18353, 15036, 15065, 15095,
                                               15126, 15156, 15187, 15218, 15248, 15279, 15309, 15340, 15371,
                                               15400, 15431, 15461, 16197, 16222, 16252, 16283, 16314, 16344,
                                               16375, 16405, 16436, 16467, 16495, 16526, 16556, 16587, 16617,
                                               16648, 16679, 16709, 16740, 16770, 16801, 16832, 16861, 16892,
                                               17198, 17226, 17257, 17532, 17897, 17928, 17956), class = "Date"),
                           end = structure(c(17317, 17347, 17378, 17409, 17439, 17470,
                                             17500, 17531, 17562, 17590, 17621, 17651, 17682, 17712, 17743,
                                             17774, 17775, 18016, 18047, 18077, 18108, 18139, 18169, 18200,
                                             18230, 18261, 18292, 18321, 18352, 18355, 15064, 15094, 15125,
                                             15155, 15186, 15217, 15247, 15278, 15308, 15339, 15370, 15399,
                                             15430, 15460, 15463, 16221, 16251, 16282, 16313, 16343, 16374,
                                             16404, 16435, 16466, 16494, 16525, 16555, 16586, 16616, 16647,
                                             16678, 16708, 16739, 16769, 16800, 16831, 16860, 16891, 16893,
                                             17225, 17256, 17261, 17561, 17927, 17955, 17960), class = "Date")), row.names = c(NA,
                                                                                                                               -76L), class = "data.frame")

  output_foo <- partition_ranges(df, "start", "end", vars_to_keep = "group", partition_by = "month")

  expect_equal(output, output_foo)

}

)
