% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetCDF.r
\name{NetCDF}
\alias{NetCDF}
\title{Information about a NetCDF file, in convenient form.}
\usage{
NetCDF(x)
}
\arguments{
\item{x}{path to NetCDF file}
}
\value{
A list of data frames with an unused S3 class 'NetCDF', see details for a description of the data frames. The 'attribute'
data frame has class 'NetCDF_attributes', this is used with a custom print method to reduce the amount of output printed.
}
\description{
\link{NetCDF} scans all the metadata provided by the \link[ncdf4:nc_open]{ncdf4::nc_open} function, and organizes it by the entities in the file.
}
\details{
Users of 'NetCDF' files might be familiar with the command line tool 'ncdump
-h' noting that the "header" argument is crucial for giving a compact summary
of the contents of a file.  This package aims to provide that information
as data, to be used for writing code to otherwise access and manipulate the
contents of the files. This function doesn't do anything with the data, and
it doesn't access any of the data.

A NetCDF file contains the following entities, and each gets a data frame in the resulting object:
\tabular{ll}{
\code{attribute} \tab 'attributes' are general metadata about the file and its variables and dimensions\cr
\code{dimension} \tab 'dimensions' are the axes defining the space of the data variables \cr
\code{variable} \tab 'variables' are the actual data, the arrays containing data values \cr
\code{group} \tab 'groups' are an internal abstraction to behave as a collection, analogous to a file. \cr
}

In addition to a data for each of the main entities above 'NetCDF' also creates:
\tabular{ll}{
\code{unlimdims} \tab the unlimited dimensions identify those which are not a constant lenghth (i.e. spread over files) \cr
\code{dimvals} \tab a link table between dimensions and its coordinates \cr
\code{file} \tab information about the file itself \cr
\code{vardim} \tab a link table between variables and their dimensions \cr

}

Currently 'file' is expected to and treated as having only one row, but future versions may treat a collection of files
as a single entity.

The 'ncdump -h' print summary above is analogous to the print method \link[ncdf4:print.ncdf4]{ncdf4::print.ncdf4} of the output of \link[ncdf4:nc_open]{ncdf4::nc_open}.
}
\examples{
rnc <- NetCDF(system.file("extdata", "S2008001.L3m_DAY_CHL_chlor_a_9km.nc", package= "ncdump"))
rnc
}
\seealso{
\link[ncdf4:nc_open]{ncdf4::nc_open} which is what this function uses to obtain the information
}
