% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFVariable.R
\docType{methods}
\name{[.CFVariable}
\alias{[.CFVariable}
\alias{bracket_select}
\title{Extract data for a variable}
\usage{
\method{[}{CFVariable}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{An \code{CFVariable} instance to extract the data of.}

\item{i, j, ...}{Expressions, one for each axis of \code{x}, that select a
number of elements along each axis. If any expressions are missing,
the entire axis is extracted. The values for the arguments may be an
integer vector or a function that returns an integer vector. The range of
the values in the vector will be used. See examples, below.}

\item{drop}{Logical, ignored. Axes are never dropped. Any degenerate
dimensions of the array are returned as such, with dimnames and appropriate
attributes set.}
}
\value{
An array with dimnames and other attributes set.
}
\description{
Extract data from a \code{CFVariable} instance, optionally sub-setting the
axes to load only data of interest.
}
\details{
If all the data of the variable in \code{x} is to be extracted, simply use \verb{[]}
(unlike with regular arrays, this is required, otherwise the details of the
variable are printed on the console).

The indices into the axes to be subset can be specified in a variety of
ways; in practice it should (resolve to) be a vector of integers. A range
(e.g. \code{100:200}), an explicit vector (\verb{c(23, 46, 3, 45, 17}), a sequence
(\verb{seq(from = 78, to = 100, by = 2}), all work. Note, however, that only a
single range is generated from the vector so these examples resolve to
\code{100:200}, \code{3:46}, and \code{78:100}, respectively. It is also possible to use a
custom function as an argument.

This method works with "bare" indices into the axes of the array. If
you want to use domain values of the axes (e.g. longitude values or
timestamps) to extract part of the variable array, use the \code{CFVariable$subset()}
method.

Scalar axes should not be included in the indexing as they do not represent a
dimension into the data array.
}
\examples{
fn <- system.file("extdata",
  "pr_day_EC-Earth3-CC_ssp245_r1i1p1f1_gr_20230101-20231231_vncdfCF.nc",
  package = "ncdfCF")
ds <- open_ncdf(fn)
pr <- ds[["pr"]]

# How are the dimensions organized?
dimnames(pr)

# Precipitation data for March for a single location
x <- pr[5, 12, 61:91]
str(x)

# Summer precipitation over the full spatial extent
summer <- pr[, , 173:263]
str(summer)
}
