% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCVariable.R
\docType{class}
\name{NCVariable}
\alias{NCVariable}
\title{NetCDF variable}
\description{
This class represents a netCDF variable, the object that holds
the properties and data of elements like dimensions and variables of a
netCDF file.
}
\details{
Direct access to netCDF variables is usually not necessary. NetCDF
variables are linked from CF data variables and axes and all relevant
properties are thus made accessible.
}
\section{Super class}{
\code{\link[ncdfCF:NCObject]{ncdfCF::NCObject}} -> \code{NCVariable}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{group}}{NetCDF group where this variable is located.}

\item{\code{vtype}}{The netCDF data type of this variable.}

\item{\code{ndims}}{Number of dimensions that this variable uses.}

\item{\code{dimids}}{Vector of dimension identifiers that this variable uses. These
are the so-called "NUG coordinate variables".}

\item{\code{netcdf4}}{Additional properties for a \code{netcdf4} resource.
Create a new netCDF variable

This class should not be instantiated directly, they are created
automatically when opening a netCDF resource.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{CF}}{List of CF objects that uses this netCDF variable.}

\item{\code{fullname}}{(read-only) Name of the NC variable including the group
path from the root group.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NCVariable-new}{\code{NCVariable$new()}}
\item \href{#method-NCVariable-shard}{\code{NCVariable$shard()}}
\item \href{#method-NCVariable-clone}{\code{NCVariable$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCObject" data-id="attribute"><a href='../../ncdfCF/html/NCObject.html#method-NCObject-attribute'><code>ncdfCF::NCObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCObject" data-id="print_attributes"><a href='../../ncdfCF/html/NCObject.html#method-NCObject-print_attributes'><code>ncdfCF::NCObject$print_attributes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCVariable-new"></a>}}
\if{latex}{\out{\hypertarget{method-NCVariable-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCVariable$new(id, name, group, vtype, ndims, dimids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Numeric identifier of the netCDF object.}

\item{\code{name}}{Character string with the name of the netCDF object.}

\item{\code{group}}{The \link{NCGroup} this variable is located in.}

\item{\code{vtype}}{The netCDF data type of the variable.}

\item{\code{ndims}}{The number of dimensions this variable uses.}

\item{\code{dimids}}{The identifiers of the dimensions this variable uses.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCVariable-shard"></a>}}
\if{latex}{\out{\hypertarget{method-NCVariable-shard}{}}}
\subsection{Method \code{shard()}}{
Very concise information on the variable

The information returned by this function is very concise and most useful
when combined with similar information from other variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCVariable$shard()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character string with very basic variable information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCVariable-clone"></a>}}
\if{latex}{\out{\hypertarget{method-NCVariable-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCVariable$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
