\name{qom}
\Rdversion{1.4.0}
\alias{qom}
\alias{qom,data.frame-method}
\title{
Quality of Match
}
\description{
Quality of matches show how well matched pairs differ.  For each variable the average distance is generated.  Each item in a pair is assigned a group and after several iterations the quantile of these average distances is returned.
}
\usage{
qom(covariate, matches, iterations=10000, probs=NA, use.se=FALSE, all.vals=FALSE, seed=101, ...)
}

\arguments{
  \item{covariate}{
A data.frame object.
}
  \item{matches}{
A data.frame object.  Contains information on how to match the covariate data set.
}
  \item{iterations}{
An integer.  Number of iterations to run, defaults to 10,000.
}
  \item{probs}{
A numeric vector.  Probabilities to pass to the quantile function.
}
  \item{use.se}{
A logical value.  Determines if the standard error should be computed.  Default value of FALSE.
}
  \item{all.vals}{
A logical value.  Determines if false matches should be included in comparison.  Default value of FALSE.
}
  \item{seed}{
Seed provided for random-number generation.  Default value of 101.
}
  \item{\dots}{
Additional arguments, not used at the moment.
}
}

\details{
This fuction is useful for determining the effectiveness of your weights (when generating a distance matrix).  Weighting a variable more will lower the average distance, but it could penalize the distance of the other variables.
Calculating the standard error requires calling \sQuote{hdquantile} from \pkg{Hmisc}.  The quantiles may be slighly different when using \sQuote{hdquantile}.
}

\value{
a list object containing elements with quality of match information
    \item{q }{data.frame with quantiles for each covariate}
    \item{se }{data.frame with standard error for each covariate}
}

\author{
Cole Beck
}

\examples{
df <- data.frame(id=LETTERS[1:25], val1=rnorm(25), val2=rnorm(25))
df.dist <- gendistance(df, idcol=1)
df.mdm <- distancematrix(df.dist)
df.match <- nonbimatch(df.mdm)
qom(df.dist$cov, df.match$matches)
}
