% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_qs.R
\name{verify_inputs_EMD}
\alias{verify_inputs_EMD}
\title{Verify the inputs to the earthmover's distance problem}
\usage{
verify_inputs_EMD(ratio, st, z)
}
\arguments{
\item{ratio}{a numeric specifying the desired ratio of controls to treated in
each stratum.}

\item{st}{a stratum vector with the \code{i}th entry equal to the
stratum of unit \code{i}. This should have the same order of units and length
as \code{z}.}

\item{z}{a treatment indicator vector with \code{i}th entry equal to 0 if
unit \code{i} is a control and equal to 1 if unit \code{i} is treated.}
}
\value{
No return value. If there is a problem with the inputs to \code{\link{generate_qs}()},
an error is raised.
}
\description{
Check that the ratio, strata, and treated indicator provided to \code{\link{generate_qs}()}
are in the correct forms and that the desired ratio is feasible
across the population.
}
\keyword{internal}
