% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_qs.R
\name{generate_qs}
\alias{generate_qs}
\title{Calculate desired number of controls per stratum}
\usage{
generate_qs(
  z,
  st,
  ratio = NULL,
  max_ratio = NULL,
  max_extra_s = 5,
  strata_dist = NULL
)
}
\arguments{
\item{z}{a treatment indicator vector with \code{i}th entry equal to 0 if
unit \code{i} is a control and equal to 1 if unit \code{i} is treated.}

\item{st}{a stratum vector with the \code{i}th entry equal to the
stratum of unit \code{i}. This should have the same order of units and length
as \code{z}.}

\item{ratio}{a numeric specifying the desired ratio of controls to treated in
each stratum.}

\item{max_ratio}{a numeric specifying the maximum ratio to allow in a stratum to achieve
the overall \code{ratio} specified. If \code{NULL}, it is set by default to 1.1 times the desired \code{ratio}.
To have no maximum ratio, set this to \code{Inf}.}

\item{max_extra_s}{single numeric or named vector with values corresponding to the maximum desired number
of extra controls to be chosen from each stratum to achieve the overall
\code{ratio} specified. If this is a vector, the names should correspond to the stratum
values from \code{st}. The default is 5 for each stratum.
To have no maximum, set this to \code{Inf}.
If both \code{max_ratio} and \code{max_s} are specified, the
maximum of the two will be used for each stratum.}

\item{strata_dist}{matrix with both row and column names with names corresponding
to the stratum values from \code{st} and entries corresponding to the distance
associated with taking a control from the stratum associated with the row when
the desired stratum is the one associated with the column. Lower distance values
are more desirable replacements. Typically the diagonal should be 0, meaning
there is no penalty for choosing a unit from the correct stratum.}
}
\value{
A named vector stating how many controls to take from each stratum.
}
\description{
Figure out how many units to take from each stratum when some strata are deficient.
The result should be used as an input to \code{\link{optimize_controls}()}.
}
