% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hxsurf.R
\name{subset.hxsurf}
\alias{subset.hxsurf}
\title{Subset hxsurf object to specified regions}
\usage{
\method{subset}{hxsurf}(x, subset = NULL, drop = TRUE, rval = c("hxsurf",
  "names"), ...)
}
\arguments{
\item{x}{A dotprops object}

\item{subset}{Character vector specifying regions to keep. Interpreted as 
\code{\link[base]{regex}} if of length 1 and no fixed match.}

\item{drop}{Whether to drop unused vertices after subsetting (default:
\code{TRUE})}

\item{rval}{Whether to return a new \code{hxsurf} object or just the names of
the matching regions}

\item{...}{Additional parameters (currently ignored)}
}
\value{
subsetted hxsurf object
}
\description{
Subset hxsurf object to specified regions
}
\examples{
# plot only vertical lobe
vertical_lobe=subset(MBL.surf, "VL")
\donttest{
plot3d(vertical_lobe, alpha=0.3)
plot3d(kcs20)

# there is also a shortcut for this
clear3d()
plot3d(MBL.surf, "VL", alpha=0.3)
}
}
\seealso{
Other hxsurf: \code{\link{as.hxsurf}},
  \code{\link{as.mesh3d.ashape3d}},
  \code{\link{materials}}, \code{\link{plot3d.hxsurf}},
  \code{\link{read.hxsurf}}, \code{\link{write.hxsurf}}
}
