% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hxsurf.R
\name{read.hxsurf}
\alias{read.hxsurf}
\alias{hxsurf}
\title{Read Amira surface (aka HxSurface or HyperSurface) files into hxsurf object}
\usage{
read.hxsurf(
  filename,
  RegionNames = NULL,
  RegionChoice = "both",
  FallbackRegionCol = "grey",
  Verbose = FALSE
)
}
\arguments{
\item{filename}{Character vector defining path to file}

\item{RegionNames}{Character vector specifying which regions should be read 
from file. Default value of \code{NULL} => all regions.}

\item{RegionChoice}{Whether the \emph{Inner} or \emph{Outer} material, or 
\emph{both} (default), should define the material of the patch. See 
details.}

\item{FallbackRegionCol}{Colour to set regions when no colour is defined}

\item{Verbose}{Print status messages during parsing when \code{TRUE}}
}
\value{
A list with S3 class hxsurf with elements \itemize{
  
  \item{Vertices}{ A data.frame with columns \code{X, Y, Z, PointNo}}
  
  \item{Regions}{ A list with 3 column data.frames specifying triplets of 
  vertices for each region (with reference to \code{PointNo} column in 
  \code{Vertices} element)}
  
  \item{RegionList}{ Character vector of region names (should match names of 
  \code{Regions} element)}
  
  \item{RegionColourList}{ Character vector specifying default colour to plot
  each region in R's \code{\link{rgb}} format}
  
  }
}
\description{
Read Amira surface (aka HxSurface or HyperSurface) files into hxsurf object
}
\details{
Note that when \code{RegionChoice="both"} or 
  \code{RegionChoice=c("Inner", "Outer")} both polygons in inner and outer 
  regions will be added to named regions. To understand the significance of 
  this, consider two adjacent regions, A and B, with a shared surface. For 
  the polygons in both A and B, Amira will have a patch with (say) 
  InnerRegion A and OuterRegion B. This avoids duplication in the file. 
  However, it might be convenient to add these polygons to both regions when 
  we read them into R, so that regions A and B in our R object are both 
  closed surfaces. To achieve this when \code{RegionChoice="both"}, 
  \code{read.hxsurf} adds these polygons to region B (as well as region A) 
  but swaps the order of the vertices defining the polygon to ensure that the
  surface directionality is correct.
  
  As a rule of thumb, stick with \code{RegionChoice="both"}. If you get more 
  regions than you wanted, then try switching to \code{RegionChoice="Inner"}
  or \code{RegionChoice="Outer"}.
}
\examples{
\dontrun{
read.hxsurf("my.surf", RegionChoice="both")
}
}
\seealso{
\code{\link{plot3d.hxsurf}, \link{rgb}}

Other amira: 
\code{\link{amiratype}()},
\code{\link{is.amiramesh}()},
\code{\link{read.amiramesh}()},
\code{\link{write.hxsurf}()}

Other hxsurf: 
\code{\link{as.hxsurf}()},
\code{\link{as.mesh3d}()},
\code{\link{materials}()},
\code{\link{plot3d.hxsurf}()},
\code{\link{subset.hxsurf}()},
\code{\link{write.hxsurf}()}
}
\concept{amira}
\concept{hxsurf}
