% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmtk_io.R
\name{cmtkreglist}
\alias{cmtkreglist}
\title{Make in-memory CMTK registration list from affine matrix or CMTK parameters}
\usage{
cmtkreglist(x, centre = c(0, 0, 0), reference = "dummy", floating = "dummy")
}
\arguments{
\item{x}{5x3 matrix of CMTK registration parameters OR 4x4 homogeneous affine
matrix}

\item{centre}{Optional centre of rotation passed to \code{affmat2cmtkparams} 
when decomposing 4x4 affine matrix}

\item{reference, floating}{Path to refererence and floating images.}
}
\value{
\code{list} of class \code{cmtkreg} containing registration
  parameters suitable for \code{\link{write.cmtkreg}}
}
\description{
Make in-memory CMTK registration list from affine matrix or CMTK parameters
}
\details{
Note that this uses the modern CMTK notation of floating_study 
  rather than model_study as used by IGSParamsToIGSRegistration (which 
  results in an implicit inversion by CMTK tools).

Note that the reference and floating fields have no impact on the 
  transformation encoded in the resultant .list folder and can be overridden 
  on the command line of CMTK tools.
}
\seealso{
\code{\link{write.cmtkreg}, \link{affmat2cmtkparams}, \link{cmtkreg}}
}
