% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dotprops.R
\name{subset.dotprops}
\alias{subset.dotprops}
\title{Subset points in dotprops object that match given conditions}
\usage{
\method{subset}{dotprops}(x, subset, ...)
}
\arguments{
\item{x}{A dotprops object}

\item{subset}{A subset of points defined by indices, an expression or a function (see Details)}

\item{...}{Additional parameters (currently ignored)}
}
\value{
subsetted dotprops object
}
\description{
Subset points in dotprops object that match given conditions
}
\details{
\code{subset} defines either logical or numeric indices, in which
  case these are simply applied to the matrices that define the \code{points}, \code{vect} fields of the \code{dotprops} object
  etc OR a function (which is called with the 3D points array and returns T/F.
  OR an expression
  vector).
}
\examples{
## subset using indices ...
dp=kcs20[[10]]
dp1=subset(dp, 1:50)

# ... or an expression
dp2=subset(dp, alpha>0.7)
front=subset(dp, points[,'Z']<40)
# use a helper function
between=function(x, lower, upper) x>=lower & x<=upper
middle=middle=subset(dp, between(points[,'Z'], 40, 60))

# plot results in 3D
plot3d(front, col='red')
plot3d(middle, col='green')
plot3d(dp, col='blue')

\dontrun{

## subset using an selection function
s3d=select3d()
dp1=subset(dp,s3d(points))
# special case of previous version
dp2=subset(dp,s3d)
# keep the points that were removed from dp2
dp2.not=subset(dp,Negate(s3d))
stopifnot(all.equal(dp1,dp2))
dp2=subset(dp,alpha>0.5 & s3d(pointd))
dp3=subset(dp,1:10)

## subset each dotprops object in a whole neuronlist
plot3d(kcs20)
s3d=select3d()
kcs20.partial = nlapply(kcs20, subset, s3d)
clear3d()
plot3d(kcs20.partial, col='red')
plot3d(kcs20, col='grey')
}
}
\seealso{
\code{prune.dotprops}, \code{subset.neuron}
}

