% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_surfaces.R
\name{query_surfaces}
\alias{query_surfaces}
\title{Query the POWER API for Detailed Information on Wind Type Surfaces}
\usage{
query_surfaces(surface_alias = NULL)
}
\arguments{
\item{surface_alias}{An optional character vector providing a wind surface
alias available from the \acronym{POWER} \acronym{API}.  All values are
returned if this value is not provided.}
}
\value{
A \link{list} object of information for the requested wind surface(s).
}
\description{
Queries the \acronym{POWER} \acronym{API} returning detailed information on
all (or just one) wind elevation surface alias and attribute information.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# fetch all wind surface information
query_surfaces()

# fetch surface information for `airportgrass`
query_surfaces(surface_alias = "airportgrass")
\dontshow{\}) # examplesIf}
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
