% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_parameters.R
\name{query_parameters}
\alias{query_parameters}
\title{Query the POWER API for detailed information on parameters}
\usage{
query_parameters(community = NULL, par = NULL, temporal_api = NULL)
}
\arguments{
\item{community}{An optional character vector providing community name:
\dQuote{ag}, \dQuote{sb} or \dQuote{re}.}

\item{par}{An optional character vector of a single solar, meteorological or
climatology parameter to query.  If unsure, omit this argument for for a
full list of all the parameters available for each temporal \acronym{API}
and community.}

\item{temporal_api}{An optional character vector indicating the temporal
\acronym{API} end-point for data being queried, supported values are
\dQuote{hourly}, \dQuote{daily}, \dQuote{monthly} or \dQuote{climatology}.}
}
\value{
A \link{list} object of information for the requested parameter(s) (if
requested), community and temporal \acronym{API}.
}
\description{
Queries the \acronym{POWER} \acronym{API} returning detailed information on
available parameters.
}
\details{
If \code{par} is not provided all possible parameters for the provided
community, \code{community} and temporal \acronym{API}, \code{temporal_api} will be
returned.  If only a single parameter is supplied with no \code{community} or
\code{temporal_api} then the complete attribute information for that parameter
will be returned for all possible communities and temporal \acronym{API}s
combinations.  If all three values are provided, only the information for
that specific combination of parameter, temporal \acronym{API} and community
will be returned.
}
\section{Argument details for \code{temporal_api}}{
 There are four valid values.
\describe{
\item{hourly}{The hourly average of \code{pars} by hour, day, month and year.}
\item{daily}{The daily average of \code{pars} by day, month and year.}
\item{monthly}{The monthly average of \code{pars} by month and year.}
\item{climatology}{Provide parameters as 22-year climatologies (solar)
and 30-year climatologies (meteorology); the period climatology and
monthly average, maximum, and/or minimum values.}
}
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# fetch the complete set of attribute information for "T2M".
query_parameters(par = "T2M")

# fetch complete temporal and community specific attribute information
# for "T2M" in the "ag" community for the "hourly" temporal API.
query_parameters(par = "T2M",
                 community = "ag",
                 temporal_api = "hourly")

# fetch complete temporal and community specific attribute information
# for all parameters in the "ag" community for the "hourly" temporal API.
query_parameters(community = "ag",
                 temporal_api = "hourly")
\dontshow{\}) # examplesIf}
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
