% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{emr_filter.name}
\alias{emr_filter.name}
\title{Generate a default name for a naryn filter}
\usage{
emr_filter.name(
  src,
  keepref = FALSE,
  time.shift = NULL,
  val = NULL,
  expiration = NULL,
  operator = "="
)
}
\arguments{
\item{src}{source (track name, virtual track name or id-time table). Can be a vector of track names.}

\item{keepref}{'TRUE' or 'FALSE'}

\item{time.shift}{time shift and expansion for iterator time}

\item{val}{selected values}

\item{expiration}{expiration period}

\item{operator}{operator for filtering. Accepts one of: "=", "<", "<=", ">", ">="}
}
\value{
a default name for the filter
}
\description{
Generate a default name for a naryn filter
}
\details{
Given filter parameters, generate a name with the following format:
"f_{src}.kr{keepref}.vals_{val}.ts_{time.shift}.exp_{expiration}.op_{operator}"
Where for 'val' and 'time.shift' the values are separated by an
underscore.

If \code{time.shift}, \code{val} or \code{expiration} are
\code{NULL} - their section would not appear in the generated name.
}
\examples{

emr_db.init_examples()
emr_filter.name("dense_track", time.shift = c(2, 4))
}
\seealso{
\code{\link{emr_filter.create}}
}
\keyword{~filter}
