% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_naptan.R
\name{call_naptan}
\alias{call_naptan}
\title{Call the NaPTAN API for all, or for specified ATCO codes. Returns a data frame of Naptan data.}
\usage{
call_naptan(atco = NULL)
}
\arguments{
\item{atco}{string or vector of strings.
First three digits of ATCO area codes of interest.
If provided, will return data for only these ATCO areas. Defaults to NULL.

To return a lookup of current valid ATCO codes, use the lookup_atco_codes() function.}
}
\value{
Returns a data frame of NaPTAN data containing transport access node information.
See \href{https://www.gov.uk/government/publications/national-public-transport-access-node-schema}{NaPTAN data set guidance} for more information.
}
\description{
Call the NaPTAN API for all, or for specified ATCO codes. Returns a data frame of Naptan data.
}
\examples{

\dontrun{
#Return data for all ATCO areas 
call_naptan()

#Return data for a single ATCO area
call_naptan(atco = "050")

#Return data for multiple atco codes
call_naptan(atco = c("050", "290")) 

}
}
