% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messenger.R
\name{messenger}
\alias{messenger}
\title{Messenger}
\usage{
messenger(url, auth = NULL)
}
\arguments{
\item{url}{a URL to connect to, specifying the transport and address as
a character string e.g. 'tcp://127.0.0.1:5555' (see \link{transports}).}

\item{auth}{[default NULL] an R object (possessed by both parties) which
serves as a pre-shared key on which to authenticate the communication.
Note: the object is never sent, only a random subset of its md5 hash
after serialization.}
}
\value{
Invisible NULL.
}
\description{
Multi-threaded, console-based, 2-way instant messaging system with
    authentication, based on NNG scalability protocols.
}
\note{
The authentication protocol is an experimental proof of concept which
    is not secure, and should not be used for critical applications.
}
\section{Usage}{


    Type outgoing messages and hit return to send.

    The timestamps of outgoing messages are prefixed by \code{>} and that of
    incoming messages by \code{<}.

    \code{:q} is the command to quit.

    Both parties must supply the same argument for \sQuote{auth}, otherwise
    the party trying to connect will receive an \sQuote{authentication error}
    and be immediately disconnected.
}

