% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{opts}
\alias{opts}
\title{Opts [Documentation]}
\description{
Options that can be set on Sockets, Contexts, Streams, Dialers
    or Listeners.

    Use \code{\link{setopt}} to set options and \code{\link{getopt}} to get
    the value of options.

    Some options are only meaningful or supported in certain contexts; for
    example there is no single meaningful address for a socket, since sockets
    can have multiple dialers and endpoints associated with them.

    For an authoritative guide please refer to the online documentation for
    the NNG library at \url{https://nng.nanomsg.org/man/}.
}
\section{Global Options}{


    \itemize{
      \item{'reconnect-time-min' [type 'ms']}

      {This is the minimum amount of time (milliseconds) to wait before
      attempting to establish a connection after a previous attempt has
      failed. This can be set on a socket, but it can also be overridden on
      an individual dialer. The option is irrelevant for listeners.}

      \item{'reconnect-time-max' [type 'ms']}

      {This is the maximum amount of time (milliseconds) to wait before
      attempting to establish a connection after a previous attempt has
      failed. If this is non-zero, then the time between successive
      connection attempts will start at the value of 'reconnect-time-min',
      and grow exponentially, until it reaches this value. If this value is
      zero, then no exponential back-off between connection attempts is done,
      and each attempt will wait the time specified by 'reconnect-time-min'.
      This can be set on a socket, but it can also be overridden on an
      individual dialer. The option is irrelevant for listeners.}

    \item{'recv-size-max' [type 'size']}

      {This is the maximum message size that the will be accepted from a
      remote peer. If a peer attempts to send a message larger than this,
      then the message will be discarded. If the value of this is zero, then
      no limit on message sizes is enforced. This option exists to prevent
      certain kinds of denial-of-service attacks, where a malicious agent
      can claim to want to send an extraordinarily large message, without
      sending any data. This option can be set for the socket, but may be
      overridden for on a per-dialer or per-listener basis.
      NOTE: Applications on hostile networks should set this to a non-zero
      value to prevent denial-of-service attacks.
      NOTE: Some transports may have further message size restrictions.}

    \item{'recv-buffer' [type 'int']}

      {This is the depth of the socket’s receive buffer as a number of
      messages. Messages received by a transport may be buffered until the
      application has accepted them for delivery. This value must be an
      integer between 0 and 8192, inclusive. NOTE: Not all protocols support
      buffering received messages. For example req can only deal with a
      single reply at a time.}

    \item{'recv-timeout' [type 'ms']}

      {This is the socket receive timeout in milliseconds. When no message is
      available for receiving at the socket for this period of time, receive
      operations will fail with a return value of 5L ('timed out').}

    \item{'send-buffer' [type 'int']}

      {This is the depth of the socket send buffer as a number of messages.
      Messages sent by an application may be buffered by the socket until a
      transport is ready to accept them for delivery. This value must be an
      integer between 0 and 8192, inclusive.
      NOTE: Not all protocols support buffering sent messages; generally
      multicast protocols like pub will simply discard messages when they
      cannot be delivered immediately.}

    \item{'send-timeout' [type 'ms']}

      {This is the socket send timeout in milliseconds. When a message cannot
      be queued for delivery by the socket for this period of time (such as
      if send buffers are full), the operation will fail with a return value
      of 5L ('timed out').}

    \item{'socket-name' [type 'string']}

      {This is the socket name. By default this is a string corresponding to
      the value of the socket. The string must fit within 64-bytes, including
      the terminating NUL byte. The value is intended for application use,
      and is not used for anything in the library itself.}

    }
}

\section{Protocol-specific Options}{


    \itemize{
      \item{'req:resend-time' [type 'ms']}

      {(Request protocol) When a new request is started, a timer of this
      duration is also started. If no reply is received before this timer
      expires, then the request will be resent. (Requests are also
      automatically resent if the peer to whom the original request was sent
      disconnects, or if a peer becomes available while the requester is
      waiting for an available peer.)}

      \item{'sub:subscribe' [type 'string']}

      {(Subscribe protocol) This option registers a topic that the subscriber
      is interested in. Each incoming message is checked against the list of
      subscribed topics. If the body begins with the entire set of bytes in
      the topic, then the message is accepted. If no topic matches, then the
      message is discarded. To receive all messages, set the topic to NULL. }

      \item{'sub:unsubscribe' [type 'string']}

      {(Subscribe protocol) This option removes a topic from the subscription
      list. Note that if the topic was not previously subscribed to with
      'sub:subscribe' then an 'entry not found' error will result.}

      \item{'sub:prefnew' [type 'bool']}

      {(Subscribe protocol) This option specifies the behavior of the
      subscriber when the queue is full. When TRUE (the default), the
      subscriber will make room in the queue by removing the oldest message.
      When FALSE, the subscriber will reject messages if the message queue
      does not have room.}

    \item{'surveyor:survey-time' [type 'ms']}

      {(Surveyor protocol) Duration of surveys. When a new survey is started,
      a timer of this duration is also started. Any responses arriving after
      this time will be discarded. Attempts to receive after the timer expires
      with no other surveys started will result in an 'incorrect state' error.
      Attempts to receive when this timer expires will result in a 'timed
      out' error.}

    }
}

\section{Transport-specific Options}{


    \itemize{
      \item{'ipc:permissions' [type 'int']}

      {(IPC transport) This option may be applied to a listener to configure
      the permissions that are used on the UNIX domain socket created by that
      listener. This property is only supported on POSIX systems. The value
      is of type int, representing the normal permission bits on a file, such
      as 0600 (typically meaning read-write to the owner, and no permissions
      for anyone else.) The default is system-specific, most often 0644.}

      \item{'tcp-nodelay' [type 'bool']}

      {(TCP transport) This option is used to disable (or enable) the use of
      Nagle's algorithm for TCP connections. When TRUE (the default),
      messages are sent immediately by the underlying TCP stream without
      waiting to gather more data. When FALSE, Nagle’s algorithm is enabled,
      and the TCP stream may wait briefly in an attempt to coalesce messages.
      Nagle’s algorithm is useful on low-bandwidth connections to reduce
      overhead, but it comes at a cost to latency. When used on a dialer or
      a listener, the value affects how newly created connections will be
      configured.}

      \item{'tcp-keepalive' [type 'bool']}

      {(TCP transport) This option is used to enable the sending of keep-alive
      messages on the underlying TCP stream. This option is FALSE by default.
      When enabled, if no messages are seen for a period of time, then a zero
      length TCP message is sent with the ACK flag set in an attempt to tickle
      some traffic from the peer. If none is still seen (after some
      platform-specific number of retries and timeouts), then the remote peer
      is presumed dead, and the connection is closed. When used on a dialer
      or a listener, the value affects how newly created connections will be
      configured. This option has two purposes. First, it can be used to
      detect dead peers on an otherwise quiescent network. Second, it can be
      used to keep connection table entries in NAT and other middleware from
      expiring due to lack of activity.}

      \item{'ws:request-headers' [type 'string']}

      {(WebSocket transport) Concatenation of multiple lines terminated by
      CRLF sequences, that can be used to add further headers to the HTTP
      request sent when connecting. This option can be set on dialers, and
      must be done before the transport is started.}

      \item{'ws:response-headers' [type 'string']}

      {(WebSocket transport) Concatenation of multiple lines terminated by
      CRLF sequences, that can be used to add further headers to the HTTP
      response sent when connecting. This option can be set on listeners,
      and must be done before the transport is started.}

    }
}

