% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tls.R
\name{base64enc}
\alias{base64enc}
\alias{base64dec}
\title{Base64 Encode / Decode}
\usage{
base64enc(x, convert = TRUE)

base64dec(x, convert = TRUE)
}
\arguments{
\item{x}{an object.}

\item{convert}{[default TRUE] whether to convert the output to a character
string or keep as a raw vector.}
}
\value{
A raw vector or character string depending on 'convert'.
}
\description{
Encodes / decodes a character string or arbitrary R object to base64 encoding.
}
\details{
For encoding: a raw vector is encoded directly, a scalar character
    string is translated to raw before encoding, whilst all other objects are
    serialised first.

    The result of encoding or decoding is always a raw vector, which is
    translated to a character string if 'convert' is TRUE, or returned
    directly if 'convert' is FALSE.

    Set 'convert' to FALSE when decoding a raw vector or serialised object,
    which may be further passed to \code{\link{unserialize}}.
}
\examples{
base64enc("hello world!")
base64dec(base64enc("hello world!"))

base64enc("hello world!", convert = FALSE)
base64dec(base64enc("hello world!", convert = FALSE))

base64enc(data.frame())
unserialize(base64dec(base64enc(data.frame()), convert = FALSE))

}
