% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast-shadows.R
\name{cast_shadow}
\alias{cast_shadow}
\title{Add a shadow column to a dataset}
\usage{
cast_shadow(data, ...)
}
\arguments{
\item{data}{data.frame}

\item{...}{One or more unquoted variable names separated by commas. These
respect the dplyr verbs \code{starts_with}, \code{contains}, \code{ends_with}, etc.}
}
\value{
data with the added variable shifted and the suffix \code{_NA}
}
\description{
Casting a shadow shifted column performs the equivalent pattern to
data %>% select(var) %>% shadow_shift(). This is a convenience function
that makes it easy to perform certain visualisations, in line with the
principle that the user should have a way to flexibly return data formats
containing information about the missing data. It forms the base building
block for the functions \code{cast_shadow_shift}, and \code{cast_shadow_shift_label}.
It also respects the dplyr verbs \code{starts_with}, \code{contains}, \code{ends_with}, etc.
to select variables.
}
\examples{

airquality \%>\% cast_shadow(Ozone)
airquality \%>\% cast_shadow(Ozone, Solar.R)
library(ggplot2)
library(magrittr)
airquality  \%>\%
  cast_shadow(Ozone,Solar.R) \%>\%
  ggplot(aes(x = Ozone,
             colour = Solar.R_NA)) +
        geom_density()

}
\seealso{
\code{\link[=cast_shadow_shift]{cast_shadow_shift()}}, \code{\link[=cast_shadow_shift_label]{cast_shadow_shift_label()}} \code{\link[=bind_shadow]{bind_shadow()}} \code{\link[=add_any_miss]{add_any_miss()}} \code{\link[=add_label_missings]{add_label_missings()}} \code{\link[=add_label_shadow]{add_label_shadow()}} \code{\link[=add_miss_cluster]{add_miss_cluster()}} \code{\link[=add_prop_miss]{add_prop_miss()}} \code{\link[=add_shadow_shift]{add_shadow_shift()}}
}
