% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n-prop-miss-complete-rows.R
\name{prop_miss_row}
\alias{prop_miss_row}
\title{Return a vector of the proportion of missing values in each row}
\usage{
prop_miss_row(data)
}
\arguments{
\item{data}{a dataframe}
}
\value{
numeric vector of the proportion of missing values in each row
}
\description{
Substitute for \code{rowMeans(is.na(data))}, but it also checks if input is NULL or
is a dataframe
}
\examples{

prop_miss_row(airquality)

}
\seealso{
\code{\link[=pct_miss_case]{pct_miss_case()}} \code{\link[=prop_miss_case]{prop_miss_case()}} \code{\link[=pct_miss_var]{pct_miss_var()}} \code{\link[=prop_miss_var]{prop_miss_var()}} \code{\link[=pct_complete_case]{pct_complete_case()}} \code{\link[=prop_complete_case]{prop_complete_case()}} \code{\link[=pct_complete_var]{pct_complete_var()}} \code{\link[=prop_complete_var]{prop_complete_var()}} \code{\link[=miss_prop_summary]{miss_prop_summary()}} \url{miss_case_summary} \url{miss_case_table} \url{miss_summary} \url{miss_var_prop} \url{miss_var_run} \url{miss_var_span} \url{miss_var_summary} \url{miss_var_table} \url{n_complete} \url{n_complete_row} \url{n_miss} \url{n_miss_row} \url{pct_complete} \url{pct_miss} \url{prop_complete} \url{prop_complete_row} \url{prop_miss}
}
