% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naaccr_factor.R
\name{split_sentineled}
\alias{split_sentineled}
\title{Separate a field's continuous and sentinel values}
\usage{
split_sentineled(x, field)
}
\arguments{
\item{x}{Vector (usually character) of codes.}

\item{field}{String giving the XML name of the NAACCR field to code.}
}
\value{
If \code{field} is a sentineled field, a \code{data.frame} with two
  columns. The first is a \code{numeric} version of the continuous values
  from \code{x}. Its name is the value of \code{field}. The second is a
  \code{factor} with levels representing the sentinel values. For all
  non-missing values in the numeric vector, the respective value in the
  factor is \code{NA}. If a value of \code{x} was not valid, the respective
  row will be \code{NA} for the continuous and flag values.

  If \code{field} is not a sentineled field, a data.frame with just \code{x}
  is returned with a warning.
}
\description{
Separate a sentineled field's values into two vectors: one with the
continuous data and one with the sentinel values.
}
\examples{
  node_codes <- c("10", "20", "90", "95", "99", NA)
  s <- split_sentineled(node_codes, "regionalNodesPositive")
  print(s)
  s[is.na(s[["regionalNodesPositive"]]), "regionalNodesPositiveFlag"]
}
